swc.constructors.TelephonyDectView = swc.base.PageView.extend({

    className: 'dect',

    models: [ 'Telephony', 'System' ],

    validation: {
        'pin': 'Telephony:dectPin'
    },

    events: {
        'swc-switcher:change .enable-dect': 'dectStatus',

        'swc-checkbox:change .show-pin-password': 'setPinState',
        'swc-checkbox:change .eco-status': 'ecoStatus',

        'keyup input.pin-original': 'onPinChange',
        'keyup input.pin-copy': 'onPinChange',

        'click .pair-dect': 'pairDect'
    },

    setTemplateData: function(){
        this.templateData = {
            dectStatus: swc.models.Telephony.get('dectStatus'),
            dectEco: swc.models.Telephony.get('dectEco'),
            pin: swc.models.Telephony.get('dectPIN')
        };
    },

    dectStatus: function(e, value){
        var self = this;

        this.showPageLoading('Updating DECT status');

        swc.models.Telephony.set('dectStatus', value);


        $.when(swc.models.Telephony.setDectStatus()).done(function(){
            self.render();
        });
    },

    ecoStatus: function(e, value){
        var element = $(this.el);

        swc.models.Telephony.set('dectEco', value);

        this.setButtonsState();
    },

    setPinState: function(e, value) {
        var pinOrigBox = $('input.pin-original'),
            pinCopyBox = $('input.pin-copy');

        if (value) {
            pinOrigBox.hide();
            pinCopyBox.show();
        } else {
            pinCopyBox.hide();
            pinOrigBox.show();
        }
    },

    onPinChange: function (e) {
        var parameters = getParameter($(e.target)),
            pinOrigBox = $('input.pin-original'),
            pinCopyBox = $('input.pin-copy');

        if ($.inArray('pin-original', parameters.parameterClasses) !== -1) {
            pinCopyBox.val(pinOrigBox.val());
        } else {
            pinOrigBox.val(pinCopyBox.val());
        }

        swc.models.Telephony.set('dectPIN', $(e.target).val());

        this.setButtonsState();
    },


    /*
    * First we check if the server is logged in. Just any AJAX call will do.
    */
    pairDect: function() {
        var self = this;
        swc.models.System.checkSessionState(function () {
            self._pairDect();
        });
    },

    _pairDect: function() {
        var self = this;

        if (!swc.models.Login.checkUserLogin()) {
            return false;
        }

        if((swc.models.Telephony.get('phones').length-2) < swc.models.Telephony.dectInternalNumbers.length){
            var pairingModal = new swc.constructors.DectPairingModalView();

            $(pairingModal.el).on('hidden', function(){
                $(pairingModal.el).remove();
                self.render();
            });

        } else {

            var modal = swc.Templates.get('telephony:device:pair:modal:manyDects').get('content'),
                div = $('<div/>', {'class':'modal'});

            div.html($.tmpl(modal, {
                localeStrings: swc.models.Locale.getLocaleStrings("telephony"),
                localeString: getTranslationStringsjQuery,
                formatDate: swc.models.Locale.formatDate
            }));

            div.on('hidden', function(){
                div.remove();
            });

            div.modal();
        }
    },

    save: function() {
        var self = this,
            deferred = new $.Deferred();

        $.when(swc.models.Telephony.setPin(), swc.models.Telephony.setDectEco())
            .done(function() {
                deferred.resolve();
            })
            .fail(function() {
                deferred.reject();
            });

        return deferred.promise();
    }
});