swc.constructors.SystemSettingsFirmwareView = swc.base.TabView.extend({

    className: 'firmware',

    models: ['System', 'apServiceLoadingState'],

    allowedMods: ['expert'],
    
    fileExtension: null,

    events: {
        'click .upgrade-config:not(.disabled)': 'onUpgradeConfig',
        'click .upgrade-process:not(.disabled)': 'onUpgradeProcess'
    },

    setTemplateData: function(){
        var buildInfo = swc.settings.application.get('build');
        
        this.templateData = {
            GlobalEnable: swc.models.Application.get('GlobalEnable'),
            npVersion: swc.models.System.get('NPVersion') || '0.0.0',
            apVersion: swc.models.System.get('APVersion') || '0.0.0',
            uiVersion: buildInfo["StargateWebUI-dev build"] ? buildInfo["StargateWebUI-dev build"] : null
        };
    },

    wrongFileModal: function(){
        var self = this;
        SWCElements.modalWindow.show({
            templateID: 'system:settings:upgrade:modal:upgrade-wrongfile',
            templateData: {
                localeStrings: swc.models.Locale.getLocaleStrings(self.pageTemplateID),
                localeString: getTranslationStringsjQuery,
                formatDate: swc.models.Locale.formatDate,
                GlobalEnable: swc.models.Application.get('GlobalEnable')
            },
            className: 'system-restore',
            onCancel: function() {
                self.clearForm();
            }
        });
    },

    processModal: function(){
        var self = this;

        SWCElements.modalWindow.show({
            templateID: 'system:settings:upgrade:modal:upgrade-process',
            templateData: {
                localeStrings: swc.models.Locale.getLocaleStrings(self.pageTemplateID),
                localeString: getTranslationStringsjQuery,
                formatDate: swc.models.Locale.formatDate
            },
            className: 'system-upgrade',
            onShow: function(){
                var element = $('.modalWindow'),
                    // Upgrade time is not fixed value; we play with it from time to time
                    // in order to be consistent with progress bar in WebUI
                    // Current value is just temporary result of experiments
                    upgradeTime = swc.models.System.maxExpectedRebootTime + swc.models.System.minExpectedRebootTime,
                    resetRuler,
                    fileField,
                    fileType,
                    file,
                    formData;
                element.find('.ruler-block').html($.tmpl(swc.Templates.get('ruler').get('content'), {
                    'className': 'reset-ruler'
                }));

                resetRuler = element.find('.reset-ruler');

                fileField = self.form.find('input[type=file]');
                fileType = fileField.attr('name');
                file = fileField[0].files[0]; // file object

                formData = new FormData();

                // append the fileobject to the formdata
                // !! the filetype should be used as the name for the entry
                formData.append(fileType, file);

                // send the POST request to /webuiUpgrade
                $.when(swc.models.System.upgradeGateway(formData))
                    .done(function(){
                        // NP sends response immediately after file with firmware was uploaded,
                        // but after that actually upgrade starts, so let's wait for a while to not ping NP too early
                        setTimeout(function() {
                            var postUpgradeCallback = function() {
                                self.clearForm();
                                swc.models.System.doReset();
                            };

                            // Which checker to use depends actually of what we are upgrading: AP or NP (+ web.rui)
                            // We upgrade NP part, this leads to Device follow this states: Down -> Initializing -> Up
                            // Only when device is Up it has sense to reboot the device
                            if (self.fileExtension === "rui") {
                                swc.models.System.whenDeviceUp(postUpgradeCallback);
                            } else if (self.fileExtension === "acs") {
                                // In case if AP upgraded, device never goes down, so device=Up returned always
                                // and we should check if APController.get() returns "UP" for the Connection state
                                swc.models.System.whenApUp(postUpgradeCallback);
                            }
                        }, swc.models.System.minExpectedRebootTime);
                    })
                    .fail(function(){
                        resetRuler.trigger('swc-ruler:finish');
                        SWCElements.modalWindow.hide();
                        self.errorModal();
                    }
                );

                setTimeout(function(){
                    resetRuler.trigger('swc-ruler:start', {time: upgradeTime});
                }, 0);
            }
        });
    },

    errorModal: function(){
        var self = this;
        SWCElements.modalWindow.show({
            templateID: 'system:settings:upgrade:modal:upgrade-error',
            templateData: {
                localeStrings: swc.models.Locale.getLocaleStrings(self.pageTemplateID),
                localeString: getTranslationStringsjQuery,
                formatDate: swc.models.Locale.formatDate
            },
            className: 'system-upgrade',
            onCancel: function() {
                self.clearForm();
            },
            onApply: function(){
                SWCElements.modalWindow.hide();
                self.confirmModal();
            }
        });
    },

    clearForm: function(){
        this.form[0].reset();
        this.$el.find('.file-name .no-file').show();
        this.$el.find('.file-name .file').hide();
    },

    onUpgradeConfig: function(){
        var self = this;

        this.form = $('#upgrade-form');

        this.form.find('#config-upgrade').off('change');
        this.form.find('#config-upgrade').on('change', function(){

            var filePath = self.form.find('input[type=file]').val();

            if(filePath.indexOf('\\') < 0){
                self.fileName = filePath;
            } else {
                self.fileName = filePath.slice(filePath.lastIndexOf("\\")+1, filePath.length);
            }
            
            // We need to save this reference to know later which call to use to check if upgrade finished
            self.fileExtension = self.fileName.slice(self.fileName.lastIndexOf(".") + 1, self.fileName.length);

            if(self.fileName){
                // file type can either be
                //   AP for application processor
                //   SOP for hgw SOP firmware
                if(self.fileExtension === 'rui'){
                    self.form.find('input[type=file]').attr('name', 'SOP');
                } else if(self.fileExtension === 'acs' && swc.models.Application.get('GlobalEnable')){
                    self.form.find('input[type=file]').attr('name', 'AP');
                } else {
                    self.wrongFileModal();
                    self.form.find('input[type=file]').val('').attr('name', 'file');
                }

                self.$el.find('.file-name .no-file').hide();
                self.$el.find('.file-name .file').html(self.fileName).show();
            } else {
                self.clearForm();
            }

            self.activateButton();
        });
    },

    onUpgradeProcess: function(e) {
        var self = this;

        // before show modal window the session state should be checked
        swc.models.System.checkSessionState(function() {
            self.processModal();
        });
    },

    activateButton: function(){
        if(this.form.find('input[type="file"]').val()){
            this.$el.find('.upgrade-process').removeClass('disabled');
        } else {
            this.$el.find('.upgrade-process').addClass('disabled');
        }
    },

    renderComplete: function(){
        if(swc.Utils.getIEVersion() > 1 && swc.Utils.getIEVersion() < 10){
            this.$el.find('.upgrade-config').addClass('disabled');
            $('#config-upgrade').remove();
        }
    }

});
