swc.constructors.SystemSettingsRebootView = swc.base.TabView.extend({

    className: 'reboot',

    models: ['System', 'apServiceState'],

    events: {
        'click .reboot-gateway': 'onProcessReboot'
    },

    preRender: function() {
        // We have to load model `apServiceLoadingState` only if AP is enabled
        if (swc.models.apServiceState.isEnabled()) {
            swc.models.apServiceLoadingState = new swc.constructors.apServiceLoadingState();
        }
    },

    onProcessReboot: function(e) {
        var self = this;

        e.preventDefault();

        // before show modal window the session state should be checked
        swc.models.System.checkSessionState(function() {
            self.processReboot();
        });
    },

    processReboot: function(){
        var rebootModal = new swc.constructors.RebootModalView();

        swc.models.Login.on('beforeLogout', rebootModal.closeModal, rebootModal);

        $(rebootModal.el).on('hidden', function(){
            $(rebootModal.el).remove();
        });

        rebootModal.$el.modal({backdrop: 'static',keyboard: false});

    }

});
