swc.constructors.RebootProcessModalView = Backbone.View.extend({
    className: 'modal reboot-gateway',

    tagName: 'div',

    events: {
        'click .close-modal': 'closeModal'
    },

    initialize: function(){
        this.template = swc.Templates.get('system:settings:reboot-process:modal');
        this.rulerTemplate = swc.Templates.get('ruler');
        this.render();
    },

    closeModal: function(){
        $(this.el).modal('hide');
    },

    render: function(){
        var self = this, element = $(this.el);
        element.html($.tmpl(self.template.get('content'), {
            localeStrings: swc.models.Locale.getLocaleStrings("system"),
            localeString: getTranslationStringsjQuery,
            formatDate: swc.models.Locale.formatDate
        }));

        element.find('.ruler-block').html($.tmpl(self.rulerTemplate.get('content'), {
            'className': 'reboot-ruler'
        }));

        setTimeout(function(){
            element.find('.reboot-ruler').trigger('swc-ruler:start', {time: swc.models.System.minExpectedRebootTime});
        }, 0);

        swc.models.System.rebootGateway(swc.models.System.minExpectedRebootTime)
            .fail(function () {
                self.$('.progress-block').addClass('hidden');
                self.$('.error-message').removeClass('hidden');
            });
        swc.models.System.on('device:up', function () {
            self.$el.modal('hide');
        });

    }

});
