swc.constructors.RebootModalView = Backbone.View.extend({
    className: 'modal reboot-gateway',

    tagName: 'div',

    hidden: false,

    events: {
        'click .cancel-reboot': 'closeModal',
        'click .start-reboot': 'startReboot'
    },

    closeModal: function(){
        $(this.el).modal('hide');
    },

    startReboot: function(e){
        e.preventDefault();

        var rebootProcessModal = new swc.constructors.RebootProcessModalView();

        swc.models.Login.on('beforeLogout', rebootProcessModal.closeModal, rebootProcessModal);

        $(rebootProcessModal.el).on('hidden', function(){
            $(rebootProcessModal.el).remove();
        });

        this.closeModal();
        rebootProcessModal.$el.modal({backdrop: 'static',keyboard: false});
    },

    initialize: function(){
        this.template = swc.Templates.get('system:settings:reboot:modal');
        this.render();
    },

    render: function(){
        var self = this, element = $(this.el);
        element.html($.tmpl(self.template.get('content'), {
            localeStrings: swc.models.Locale.getLocaleStrings("system"),
            localeString: getTranslationStringsjQuery,
            formatDate: swc.models.Locale.formatDate
        }));
    }

});