swc.constructors.SystemSettingsGatewayView = swc.base.TabView.extend({

    className: 'gateway',

    passwordChanged: false,

    models: ['System', 'PasswordRecovery'],

    events: {
        'swc-checkbox:change .show-current-password': 'showPassword',
        'swc-checkbox:change .enable-recovery': 'changeRecovery',
        'keyup input[class*=password]': 'passChanged',
        'change input[class*=password]': 'passChanged',
        'change input.new-password-1': 'validatePassword',
        'change input.new-password-2': 'validatePassword'
    },

    setTemplateData: function() {
        this.templateData = {
            recoveryEnable: swc.models.PasswordRecovery.get('recoveryEnable')
        };
    },

    changeRecovery: function(e, value) {
        var self = this;
        swc.models.PasswordRecovery.set('recoveryEnable', value);
        this.activateButtons();
    },

    passChanged: function() {
        var currentPass = this.$('input[name=current-password]').val(),
            newPass1 = this.$('input[name=new-password-1]').val(),
            newPass2 = this.$('input[name=new-password-2]').val();

        // If at least one of password fields are not empty, we will validate them
        this.passwordChanged = currentPass || newPass1 || newPass2;

        this.activateButtons();
    },

    /**
     * Save "recovery" status if it was changed
     */
    applyRecovery: function() {
        var self = this,
            deferred = new $.Deferred();

        function saveData() {
            $.when(swc.models.PasswordRecovery.sync("update"))
                .done(function() {
                    SWCElements.modalWindow.hide();
                    deferred.resolve();
                });
        }

        if (swc.models.PasswordRecovery.get('recoveryEnable')) {
            saveData();
        } else {
            SWCElements.modalWindow.show({
                templateID: 'system:settings:gateway:modal:set-recovery',
                templateData: {
                    localeStrings: swc.models.Locale.getLocaleStrings(self.pageTemplateID),
                    localeString: getTranslationStringsjQuery,
                    formatDate: swc.models.Locale.formatDate
                },
                className: 'cloud-unchecked',
                
                onCancel: function() {
                    swc.models.PasswordRecovery.set('recoveryEnable', true);
                    deferred.reject();
                },
                
                onApply: function() {
                    saveData();
                }
            });
        }

        return deferred.promise();
    },

    /**
     * Change password
     */
    applyPassword: function() {
        var self = this,
            deferred = new $.Deferred(),
            currentPass = this.$('input[name=current-password]').val(),
            newPass1 = this.$('input[name=new-password-1]').val(),
            newPass2 = this.$('input[name=new-password-2]').val();
        
        this.$('.save-success, .save-error').hide();

        function changePassword() {
            $.when(swc.models.Login.changePassword(newPass1))
                .done(function(resp) {
                    if (!resp) {
                        deferred.reject();
                    } else {
                        deferred.resolve();
                    }
                })
                .fail(function() {
                    deferred.reject();
                });
        }

        if (self.validatePasswordsMatch()) {
            $.when(swc.models.System.checkPassword(currentPass))
                .done(function(resp) {
                    if (!resp) {
                        deferred.reject();
                    } else {
                        changePassword();
                    }
                })
                .fail(function() {
                    deferred.reject();
                });
        } else {
            deferred.reject();
        }

        return deferred.promise();
    },

    /**
     * if 'recovery' status was changed - at the first save recovery status, then save password
     */
    save: function() {
        var self = this,
            deferred = $.Deferred();

        swc.models.System.checkSessionState(function () {
            if (swc.models.PasswordRecovery.hasChanged() && self.passwordChanged) {
                $.when(self.applyRecovery())
                    .always(function () {
                        $.when(self.applyPassword())
                            .done(function() {
                                deferred.resolve();
                            })
                            .fail(function() {
                                deferred.reject();
                            });
                    });
            } else if (swc.models.PasswordRecovery.hasChanged()) {
                $.when(self.applyRecovery())
                    .done(function() {
                        deferred.resolve();
                    })
                    .fail(function() {
                        deferred.reject();
                    });
            } else {
                $.when(self.applyPassword())
                    .done(function() {
                        deferred.resolve();
                    })
                    .fail(function() {
                        deferred.reject();
                    });
            }
        });

        return deferred.promise();
    },

    showPassword: function() {
        var self = this,
            visibleField = this.$('input[name=current-password]'),
            invisibleField = this.$('input[name=current-password-copy]'),
            visibleField1 = this.$('input[name=new-password-1]'),
            invisibleField1 = this.$('input[name=new-password-1-copy]'),
            visibleField2 = this.$('input[name=new-password-2]'),
            invisibleField2 = this.$('input[name=new-password-2-copy]');

        invisibleField.val(visibleField.val());
        invisibleField1.val(visibleField1.val());
        invisibleField2.val(visibleField2.val());

        visibleField.removeClass('current-password')
            .addClass('current-password-copy')
            .attr('name', 'current-password-copy');

        invisibleField.addClass('current-password')
            .removeClass('current-password-copy')
            .attr('name', 'current-password');

        visibleField1.removeClass('new-password-1')
            .addClass('new-password-1-copy')
            .attr('name', 'new-password-1-copy');

        invisibleField1.addClass('new-password-1')
            .removeClass('new-password-1-copy')
            .attr('name', 'new-password-1');

        visibleField2.removeClass('new-password-2')
            .addClass('new-password-2-copy')
            .attr('name', 'new-password-2-copy');

        invisibleField2.addClass('new-password-2')
            .removeClass('new-password-2-copy')
            .attr('name', 'new-password-2');

        self.delegateEvents();
    },

    activateButtons: function() {
        var self = this;

        if (this.pageCheckDefaultValues()) {
            this.$('.buttons-container-message a').addClass('disabled');
        } else {
            this.$('.buttons-container-message a').removeClass('disabled');
        }
    },

    /**
     * New password validation
     * @returns {boolean}
     */
    validatePassword: function() {
        var self = this,
            newPass1 = this.$('input[name=new-password-1]'),
            newPass1Val = $.trim(newPass1.val()),
            validationMessages = [];

        this.$('.validation-message').hide();
        this.$('input').removeClass('error valid');

        // Check initial password
        if (newPass1Val) {
            if (!window.validatePassword(newPass1Val)) {
                validationMessages.push('invalid password');
            }
        } else if (!newPass1Val) {
            validationMessages.push('invalid password');
        }

        if (validationMessages.length > 0) {
            newPass1.addClass('error').siblings('input').addClass('error');
            this.$('.pass1.validation-message, .pass1 .validation-message, .pass1 .error-message').show();
        } else {
            newPass1.addClass('valid').siblings('input').addClass('valid');
        }

        return validationMessages.length === 0;
    },

    /**
     * Check if password confirmed right
     * @returns {boolean}
     */
    validatePasswordsMatch: function () {
        var self = this,
            newPass1 = this.$('input[name=new-password-1]'),
            newPass1Val = $.trim(newPass1.val()),
            newPass2 = this.$('input[name=new-password-2]'),
            newPass2Val = $.trim(newPass2.val()),
            validationMessages = [];

        // Check confirmation password
        if (newPass2Val) {
            if (newPass1Val !== newPass2Val) {
                validationMessages.push('passwords do not match');
            }
        } else {
            validationMessages.push('passwords do not match');
        }

        if (validationMessages.length > 0) {
            newPass2.addClass('error').siblings('input').addClass('error');
            this.$('.pass2.validation-message, .pass2 .validation-message, .pass2 .error-message').show();
        } else {
            newPass2.addClass('valid').siblings('input').addClass('valid');
        }

        return validationMessages.length === 0;
    }

});
