swc.constructors.SystemDisplayView = swc.base.PageView.extend({

    className: 'system-display',

    models: ['Screen'],

    events: {
        'swc-dropdown:change .time-selection': 'changeSettings',
        'swc-dropdown:change .language-selection': 'changeSettings',
        'swc-checkbox:change .show-wifi-password': 'changeSettings'
    },

    setTemplateData: function() {
        this.templateData = {
            time: swc.models.Screen.get('brightTime'),
            lang: swc.models.Screen.get('lang'),
            show: swc.models.Screen.get('showPass')
        };
    },

    activateButtons: function() {
        if (this.pageCheckDefaultValues()) {
            this.$('.buttons-container-message a').addClass('disabled');
        } else {
            this.$('.buttons-container-message a').removeClass('disabled');
        }
    },

    changeSettings: function() {
        var self = this;

        swc.models.Screen.set({
            'brightTime': this.$('.swc-dropdown.time-selection').data('value'),
            'lang': this.$('.swc-dropdown.language-selection').data('value'),
            'showPass': this.$('.swc-checkbox.show-wifi-password').data('value')
        });

        this.activateButtons();
    },

    save: function(e) {
        var deferred = new $.Deferred();

        $.when(swc.models.Screen.setParameters())
            .done(function() {
                deferred.resolve();
            })
            .fail(function () {
                deferred.reject();
            });

        return deferred.promise();
    },

    renderComplete: function() {
        var self = this,
            timeEl = this.$('.swc-dropdown.time-selection'),
            langEl = this.$('.swc-dropdown.language-selection'),
            showEl = this.$('.swc-checkbox.show-wifi-password');

        var localeSec = swc.models.Locale.getLocaleStrings("system").sec;

        timeEl.data('options', {
            '30': {
                'value': '30',
                'name': '30 '+localeSec
            },
            '60': {
                'value': '60',
                'name': '60 '+localeSec
            },
            '120': {
                'value': '120',
                'name': '120 '+localeSec
            }
        });

        langEl.data('options', {
            'DE': {
                'value': 'DE',
                'name': 'Deutsch'
            },
            'FR': {
                'value': 'FR',
                'name': 'Français'
            },
            'IT': {
                'value': 'IT',
                'name': 'Italiano'
            },
            'EN': {
                'value': 'EN',
                'name': 'English'
            }
        });

        timeEl.trigger('swc-dropdown:swc-change', swc.models.Screen.get('brightTime'));
        langEl.trigger('swc-dropdown:swc-change', swc.models.Screen.get('lang'));
        showEl.trigger('swc-checkbox:swc-change', swc.models.Screen.get('showPass'));
    }

});