swc.constructors.SystemDiagnosticsOverviewView = swc.base.TabView.extend({

    className: 'overview',

    events: {
        'click .export-log': 'exportLogs'
    },

    models: ['Network', 'System', 'DeviceMeasurements', 'DynDNS', 'DynDNSProviderCollection'],

    exportLogs: function(e){
        swc.models.System.getLogs();
    },

    setTemplateData: function(){
        var dnsProvider = swc.models.DynDNSProviderCollection.at(0),
            dnsProviderData;
        
        if (!_.isEmpty(dnsProvider)) {
            var lastUpdate = dnsProvider.get('last_update');

            if (lastUpdate && lastUpdate !== "0001-01-01T00:00:00Z") {
                lastUpdate = moment(lastUpdate).zone(lastUpdate).format("DD.MM.YYYY, HH:mm");
            } else {
                lastUpdate = '';
            }

            dnsProviderData = {
                service: dnsProvider.get('service').capitalize(),
                status: dnsProvider.get('status'),
                lastUpdate: lastUpdate
            };
        }
        
        this.templateData = {
            'netStatus': swc.models.Network.get('status').toJSON(),
            'GlobalEnable': swc.models.Application.get('GlobalEnable'),
            'dyndnsStatus': swc.models.DynDNS.get('enable'),
            'dnsProviderData': dnsProviderData
        };
        _.extend(
            this.templateData,
            swc.models.DeviceMeasurements.getParams()
        );
    }
});
