swc.constructors.GatewayPasswordModalView = Backbone.View.extend({
    className: 'modal gateway-password',

    tagName: 'div',

    hidden: false,

    events: {
        'click .logout': 'startLogout'
    },

    startLogout: function(){
        $(this.el).modal('hide');
        this.remove();
        swc.models.Login.processLogout({ action: 'user-logout' });
    },

    initialize: function(){
        this.template = swc.Templates.get('system:settings:gateway:modal');
        this.render();
    },

    render: function(){
        var self = this, element = $(this.el);
        element.html($.tmpl(self.template.get('content'), {
            localeStrings: swc.models.Locale.getLocaleStrings("system"),
            localeString: getTranslationStringsjQuery,
            formatDate: swc.models.Locale.formatDate
        }));
    }

});