swc.constructors.SystemDiagnosticsGatewayView = swc.base.TabView.extend({

    className: 'gateway',

    models: ['System', 'Network', 'FirewallStatus'],

    setTemplateData: function() {
        var systemData = swc.models.System.attributes,
            wanData = swc.models.Network.get('status').attributes;

        this.templateData = {
            'build': swc.settings.application.get('build'),
            'manufacturer': systemData.manufacturer,
            'serial': systemData.serialNumber,
            'model': systemData.model,
            'localIP': swc.models.Network.get('ip-settings').get('LocalIPAddress'),
            'localIPv6': swc.Utils.formatIPv6Address(wanData.IPv6Address),
            'storageIP': wanData.StorageIPAddress,
            'mac': wanData.MacAddress,
            'NPFirmware': systemData.NPVersion || '0.0.0',
            'APFirmware': systemData.APVersion || '0.0.0',
            'IPv6Status': swc.models.FirewallStatus.get('state').Enable,
            'GlobalEnable': swc.models.Application.get('GlobalEnable')
        };
    },

    renderComplete: function(){
        var self = this,
            element = $(this.el),
            systemData = swc.models.System.attributes;

            // generates object
            // d: { translation: "d0", value: 0 },
            // h: { translation: "h", value: 23 },
            // m: { translation: "h1", value: 1 }
            var upTime = _.object(_.map(systemData.upTime, function(value, key) {
                var item, translation;

                if (value === 0) {
                    translation = key + '0';
                } else if (value === 1) {
                    translation = key + '1';
                } else {
                    translation = key;
                }

                item = [
                    key, {
                        value: value,
                        translation: translation
                    }
                ];

                return item;
            }));

        element.find('.uptime').html($.tmpl(swc.Templates.get('system:diagnostics:upTimeTmpl').get('content'), {
            localeStrings: swc.models.Locale.getLocaleStrings("system"),
            localeString: getTranslationStringsjQuery,
            formatDate: swc.models.Locale.formatDate,
            upTime: upTime
        }));
    }
});
