swc.constructors.PowerView = swc.base.PageView.extend({

    className: 'power-settings',

    models: ['Wireless', 'Schedulers', 'Telephony', 'ApplicationPart'],

    events: {
        'click .power-settings-cancel:not(.disabled)': 'cancelSettings',
        'click .power-settings-apply:not(.disabled)': 'applySettings',
        'swc-checkbox:change .wifi .enable-service-schedule':'changeWifiScheduler',
        'swc-checkbox:change .storage .enable-service-schedule':'changeStorageScheduler',
        'swc-checkbox:change .enable-eco-mode':'enableEcoMode',
        'expandable:open .expandable-list': 'expandableOpen',
        'swc-switcher:change .swc-switcher.enable-wifi-service': 'changeWifiState',
        'swc-switcher:change .swc-switcher.enable-storage-service': 'changeAPState',
        'swc-switcher:change .swc-switcher.enable-dect-service': 'changeDectState'

    },

    changedScheduler: false,

    changeWifiScheduler: function(e, value){
        swc.models.Schedulers.get('wifi').set('enable', value);
        this.renderComplete();
        this.activateButtons();
    },

    changeStorageScheduler: function(e, value){
        swc.models.Schedulers.get('ap').set('enable', value);
        this.renderComplete();
        this.activateButtons();
    },

    enableEcoMode: function(e, value){
        swc.models.Telephony.set('dectEco', value);
        this.renderComplete();
        this.activateButtons();
    },

    changeWifiState: function(e, value){
        var self = this;
        self.changedScheduler = false;
        // Show saving page state:
        this.showPageLoading(getTranslationStrings("Saving page data.."));

        // Send requests to update wifi status on the device:
        $.when(
                swc.models.Wireless.setGlobalStatus(value)
            ).done(function() {
                $.when(swc.models.Wireless.sync()).done(function() {
                    self.render();
                });
            });
    },

    changeAPState: function(e, value){
        var self = this;
        self.changedScheduler = false;
        // Show saving page state:
        this.showPageLoading(getTranslationStrings("Saving page data.."));

        swc.models.ApplicationPart.set('serviceState', value);

        $.when(swc.models.ApplicationPart.setServiceState()).done(function() {
            self.render();
        });
    },

    changeDectState: function(e, value){
        var self = this;
        self.changedScheduler = false;
        // Show saving page state:
        this.showPageLoading(getTranslationStrings("Saving page data.."));

        swc.models.Telephony.set('dectStatus', value);

        $.when(swc.models.Telephony.setDectStatus()).done(function() {
            self.render();
        });

    },

    expandableOpen: function(e, value){
        this.openedItem = value;
    },

    cancelSettings: function(){
        this.changedScheduler = false;
        this.render();
    },

    activateButtons: function(){
        var self = this;
        if (this.changedScheduler || !this.pageCheckDefaultValues()) {
            this.$('.save-success').hide();
            this.$('.buttons-container-message a').removeClass('disabled');
        } else {
            this.$('.buttons-container-message a').addClass('disabled');
        }
    },

    applySettings: function(){
        var self = this, empty = swc.models.Schedulers.emptySchedulers, deferredsArray = [];
        self.changedScheduler = false;

        if (empty.length > 1) {
            self.bothModal();
        } else if (empty[0] === 'wifi') {
            self.wifiModal();
        } else if (empty[0] === 'ap') {
            self.storageModal();
        } else {
            self.showPageLoading(getTranslationStrings("Saving power settings.."));
            deferredsArray = [swc.models.Schedulers.addSchedule('wifi'), swc.models.Telephony.setDectEco()];
            if (swc.models.Application.get('GlobalEnable')) {
                deferredsArray.push(swc.models.Schedulers.addSchedule('ap'));
            }
            $.when.apply(this, deferredsArray).done(function(){
                self.showSuccessMessage = true;
                self.render();
            });
        }
    },

    wifiModal: function(){
        var self = this;

        SWCElements.modalWindow.show({
            templateID: 'power:wifi:modal',
            templateData: {
                localeStrings: swc.models.Locale.getLocaleStrings(self.pageTemplateID),
                localeString: getTranslationStringsjQuery,
                formatDate: swc.models.Locale.formatDate
            },
            className: 'storage-schedule',
            onCancel: function() {
                $.when(swc.models.Schedulers.addSchedule('ap'), swc.models.Telephony.setDectEco()).done(function(){
                    self.render();
                });
            },
            onApply: function() {
                SWCElements.modalWindow.hide();
                self.showPageLoading(getTranslationStrings('Saving page data..'));
                $.when(
                        swc.models.Schedulers.addSchedule('wifi'),
                        swc.models.Schedulers.addSchedule('ap'),
                        swc.models.Telephony.setDectEco(),
                        swc.models.Wireless.setGlobalStatus(false)
                    ).done(function(){
                        self.render();
                    });
            }
        });
    },

    storageModal: function(){
        var self = this;

        SWCElements.modalWindow.show({
            templateID: 'power:ap:modal',
            templateData: {
                localeStrings: swc.models.Locale.getLocaleStrings(self.pageTemplateID),
                localeString: getTranslationStringsjQuery,
                formatDate: swc.models.Locale.formatDate
            },
            className: 'storage-schedule',
            onCancel: function() {
                $.when(swc.models.Schedulers.addSchedule('wifi'), swc.models.Telephony.setDectEco()).done(function(){
                    self.render();
                });
            },
            onApply: function() {
                SWCElements.modalWindow.hide();
                swc.models.ApplicationPart.set('serviceState', false);
                self.showPageLoading(getTranslationStrings('Saving page data..'));
                $.when(
                        swc.models.Schedulers.addSchedule('wifi'),
                        swc.models.Schedulers.addSchedule('ap'),
                        swc.models.Telephony.setDectEco(),
                        swc.models.ApplicationPart.setServiceState()
                    ).done(function(){
                        self.render();
                    });
            }
        });

    },

    bothModal: function(){
        var self = this;

        SWCElements.modalWindow.show({
            templateID: 'power:both:modal',
            templateData: {
                localeStrings: swc.models.Locale.getLocaleStrings(self.pageTemplateID),
                localeString: getTranslationStringsjQuery,
                formatDate: swc.models.Locale.formatDate
            },
            className: 'storage-schedule',
            onCancel: function() {
                $.when(swc.models.Telephony.setDectEco()).done(function(){
                    self.render();
                });
            },
            onApply: function() {
                SWCElements.modalWindow.hide();
                swc.models.ApplicationPart.set('serviceState', false);
                self.showPageLoading(getTranslationStrings('Saving page data..'));
                $.when(
                        swc.models.Schedulers.addSchedule('wifi'),
                        swc.models.Schedulers.addSchedule('ap'),
                        swc.models.Telephony.setDectEco(),
                        swc.models.Wireless.setGlobalStatus(false)
                    ).done(function(){
                        // We should turn off AP after all
                        $.when(swc.models.ApplicationPart.setServiceState()).done(function(){
                            self.render();
                        });
                    });
            }
        });
    },

    setTemplateData: function(){
        var wifiState,
            apState,
            dectState,
            dectEcoState,
            wifiSchedulerModel,
            apSchedulerModel;


        wifiState = (swc.models.Wireless.getParameter("status", "status") === 'on');
        apState = swc.models.ApplicationPart.get('serviceState');

        wifiSchedulerModel = swc.models.Schedulers.get('wifi');
        apSchedulerModel = swc.models.Schedulers.get('ap');

        dectState = swc.models.Telephony.get('dectStatus');
        dectEcoState = swc.models.Telephony.get('dectEco');

        this.templateData = {
            wifiState: wifiState,
            wifiSchedule: wifiSchedulerModel.get('enable'),
            apState: apState,
            apSchedule: apSchedulerModel.get('enable'),
            dectActivated: dectState,
            dectEco: dectEcoState,
            GlobalEnable: swc.models.Application.get('GlobalEnable')
        };
    },

    renderComplete: function(){
        var self = this,
            wifiSchedulerModel,
            apSchedulerModel,
            wifiState,
            apState,
            dectState,
            dectEcoState,
            wifiStatusBlock,
            apStatusBlock,
            dectStatusBlock;

        this.setTemplateData();

        wifiState = (swc.models.Wireless.getParameter("status", "status") === 'on');
        apState = swc.models.ApplicationPart.get('serviceState');

        dectState = swc.models.Telephony.get('dectStatus');
        dectEcoState = swc.models.Telephony.get('dectEco');

        wifiSchedulerModel = swc.models.Schedulers.get('wifi');
        apSchedulerModel = swc.models.Schedulers.get('ap');

        wifiStatusBlock = this.$('.wifi-statuses');
        apStatusBlock = this.$('.ap-statuses');
        dectStatusBlock = this.$('.dect-statuses');

        $('.wifi-statuses, .dect-statuses, .ap-statuses').find('.text span').hide();
        $('.leaf').removeClass('disabled');

        if (wifiSchedulerModel.get('enable') && wifiState) {
            wifiStatusBlock.find('.text .activated-schedule').show();
        } else if (wifiState) {
            wifiStatusBlock.find('.leaf').addClass('disabled');
            wifiStatusBlock.find('.text .not-activated').show();
        } else {
            wifiStatusBlock.find('.text .activated-disable').show();
        }

        if (apSchedulerModel.get('enable') && apState) {
            apStatusBlock.find('.text .activated-schedule').show();
        } else if (apState) {
            apStatusBlock.find('.leaf').addClass('disabled');
            apStatusBlock.find('.text .not-activated').show();
        } else {
            apStatusBlock.find('.text .activated-disable').show();
        }

        if (dectEcoState && dectState) {
            dectStatusBlock.find('.text .activated-eco').show();
        } else if (dectState) {
            dectStatusBlock.find('.leaf').addClass('disabled');
            dectStatusBlock.find('.text .not-activated').show();
        } else {
            dectStatusBlock.find('.text .activated-disable').show();
        }

        swc.constructors.dispatcher.off('scheduler:change');
        swc.constructors.dispatcher.on('scheduler:change', function(){
            self.changedScheduler = true;
            self.activateButtons();
        });

        var wifiBlock = this.$('.expandable-list-item.wifi'),
            storageBlock = this.$('.expandable-list-item.storage');

        var wifiScheduler = new swc.constructors.SchedulerLiner({
            isDisabled: !self.templateData.wifiSchedule,
            scaleWidth: 432,
            diapazones: wifiSchedulerModel.get('pixelSchedule'),
            model: wifiSchedulerModel,
            schedulerType: 'wifi'
        });

        var storageScheduler = new swc.constructors.SchedulerLiner({
            isDisabled: !self.templateData.apSchedule,
            scaleWidth: 432,
            diapazones: apSchedulerModel.get('pixelSchedule'),
            model: apSchedulerModel,
            schedulerType: 'storage'
        });

        wifiBlock.find('.scheduler-container').empty().append(wifiScheduler.el);
        storageBlock.find('.scheduler-container').empty().append(storageScheduler.el);

        if (!self.openedItem) {
            self.openedItem = this.$('.expandable-list-item').eq(0).attr('data-key');
        }

        this.$(".expandable-list").trigger('expandable:swc-open', self.openedItem);

        self.checkPermissions();

        if (this.showSuccessMessage) {
            this.showSuccessMessage = false;
            this.$('.save-success').show();
        }
    }

});
