swc.constructors.ParentalView = swc.base.PageView.extend({

    className: 'parental-control',

    models: [
        'NetworkDevices',
        'Schedulers'
    ],

    events: {
        'swc-switcher:change .parental-activate': 'switchParental',
        'expandable:open .expandable-list': 'expandableOpen',
        'expandable:close .expandable-list': 'expandableClose',
        'hover .expandable-list-item:not(.expanded) .device-name': 'highlightIcon'
    },

    highlightIcon: function(event){
        var $icon = $(event.target).closest('.device-name').find('.device.small');

        if (event.type==='mouseenter') {
            $icon.addClass('selected');
        } else {
            $icon.removeClass('selected');
        }
    },

    expandableOpen: function(e, value) {
        this.openedItem = value;
    },

    expandableClose: function(e, value) {
        if (this.openedItem === value) {
            this.openedItem = "";
        }
    },

    save: function() {
        var self = this,
            deferred =  new $.Deferred();

        $.when(swc.models.Schedulers.setDevicesSchedulers())
            .done(function() {
                self.changedScheduler = false;
                deferred.resolve();
            }).fail(function() {
                deferred.reject();
            });

        return deferred.promise();
    },

    switchParental: function(e, value) {
        var element = $(e.target),
            self = this,
            deviceId = element.closest('.expandable-list-item').attr('data-key'),
            model = swc.models.Schedulers.get(deviceId);

        model.set('enable', !!value);
        
        this.showPageLoading("Saving page data..");
        
        $.when(swc.models.Schedulers.addSchedule(deviceId)).done(function() {
            self.changedScheduler = false;
            self.render();
        });
    },

    renderComplete: function() {
        var self = this;
        $.when(swc.models.Schedulers.getDevicesSchedulers()).done(function() {
            self.stopPageLoading();
            self.renderAfterComplete();
        });
    },

    renderAfterComplete: function() {
        var self = this;

        var expandableObj = {
            titleBlocks: {
                "device-name": {
                    translationString: "Device Name"
                },
                "parental-control": {
                    translationString: "Parental Control"
                }
            },

            itemsBlocks: {},

            locales: swc.models.Locale.getLocaleStrings('parental')

        };

        var ItemBlockConstructor = function(deviceName, icon, conType, key, isConnected) {
            this.isEditAble = false;
            this.isDeleteAble = false;
            this.hiddenPart = {
                templateID: "parental:expandable:hidden-part",
                templateValues: {}
            };

            this.blocks = {
                "visible-part": {
                    templateID: "parental:expandable:visible-part",
                    templateValues: {
                        deviceName: deviceName,
                        icon: icon,
                        conType: conType,
                        key: key,
                        isConnected: isConnected
                    }
                }
            };
        };

        swc.constructors.dispatcher.off('scheduler:change');
        swc.constructors.dispatcher.on('scheduler:change', function(e) {
            self.changedScheduler = true;
            self.$('.save-changes, .cancel-changes').removeClass('disabled');
        });

        var key = 1,
            thirtyDays = 30*24*3600000,

            // Currently connected devices MUST be shown on the top of the list:
            // the devices with parental control settings activated first, then - not activated.
            // Recently connected devices MUST be shown below the currently connected devices:
            // the devices with parental control settings activated first, then - not activated.
            // model.get('active') - currently connected
            // model.get('enable') - parental control
            schedulers = swc.models.Schedulers
                .chain()
                .filter(function(model){
                    return !_.contains(['ap', 'wifi'], model.get('id'));
                })
                .sortBy(function(model){
                    return -( (model.get('active') ? 1 : 0) * 2 + (model.get('enable') ? 1 : 0) );
                })
                .value();

        _.each(schedulers, function(schedule) {
            var device = swc.models.NetworkDevices.where({'mac': schedule.get('id')})[0];

            if (key < 200 && device) {
                var deviceName = device.get('name'),
                    isActive = device.get('status'),
                    connectionType = device.get('interfaceType'),
                    icon = device.get('icon'),
                    mac = device.get('mac'),
                    isEnabled = schedule.get('enable') ? true : false,

                    // we use moment.js here for date conversion because IE sometimes cannot parse
                    // the format that is coming from the serverside
                    lastConnection = moment(device.get('lastConnection')).unix() * 1000,
                    now = new Date().getTime();

                if (isEnabled || now - lastConnection < thirtyDays) {
                    expandableObj.itemsBlocks[mac] =
                        new ItemBlockConstructor(deviceName, icon, connectionType, key, isActive);
                    key++;
                }
            }
        });


        this.$('.expandable-devices').html(
            self.generateExpandableList(expandableObj)
        );

        _.map(expandableObj.itemsBlocks, function(objItem, mac){
            var connected = objItem.blocks['visible-part'].templateValues.isConnected;
            self.$el.find(".expandable-list-item[data-key='"+mac+"']").addClass( connected ? "connected" : "disconnected" );
        });

        this.$('.expandable-devices .scheduler-container').each(function() {
            var container = $(this);
            var deviceId = container.closest('.expandable-list-item').attr('data-key');
            var deviceModel = swc.models.Schedulers.find(function(model) {
                return model.id === deviceId;
            });

            var isDisabled = !deviceModel.get('enable');

            container.closest('.expandable-list-item').find('.parental-activate')
                .trigger('swc-switcher:swc-change', !isDisabled);

            var template = new swc.constructors.SchedulerLiner({
                'isDisabled': isDisabled,
                'scaleWidth' : 432,
                'diapazones' : deviceModel.get('pixelSchedule'),
                'model': deviceModel,
                'schedulerType': 'device'
            });
            container.html(template.el);
        });

        if (!self.openedItem) {
            self.openedItem = this.$('.expandable-list-item').eq(0).attr('data-key');
        }

        this.$(".expandable-list").trigger('expandable:swc-open', self.openedItem);
    }
});
