swc.constructors.OverviewView = swc.base.PageView.extend({

    className: 'overview',

    events: {
        'click .cloud-login-button': 'loginToCloudService',

        'click .customize-device': 'editDevice',
        'click .customize-dect': 'editDect',
        'click .usb-secure-remove': 'secureRemoveUSB',

        'click .js-go-to-cloud': 'navigateToCloudManagment',

        'swc-switcher:change .set-wifi-state': 'setWiFiState',
        'swc-switcher:change .set-dect-state': 'setDECTState',
        'swc-switcher:change .set-central-storage-state': 'setCentralStorageState'
    },

    listenerInterval: 10,

    listenerEnabled: true,

    listenerPages: [
        'overview'
    ],

    models: [
        'Schedulers', 'CentralStorage', 'СloudServicesStatus', 'CloudAccountCollection', 'CloudServices',
        'Telephony', 'Network', 'NetworkDevices', 'DHCPLeases',
        'FirewallStatus', 'InternetBackupStick'
    ],

    stripDeviceName: function(name, show_chars) {
        var correct = name,
            limit = show_chars || 18;

        if (correct.length > limit) {
            correct = correct.substr(0, 15) + '...';
        }

        return correct;
    },

    navigateToCloudManagment: function () {
        swc.router.navigate('storage/settings/cloud-backup/list', { trigger: false, skipUnsavedChanges: true});
    },

    setTemplateData: function() {
        var phones = swc.models.Telephony.getPhonesList(),
            phoneLines = swc.models.Telephony.get('voip') ?
                swc.models.Telephony.get('voip').where({'enable': 'Enabled'}) : [],
            models = swc.models.CloudAccountCollection.models,
            cloud = !_.isEmpty(models) ? models[0].getExtendedJSON() : '';

        this.templateData = {
            'dectStatus': swc.models.Telephony.get('dectStatus'),
            'voipStatus': swc.models.Telephony.get('voipStatus'),
            'wiredPhones': !_.isEmpty(phones.cord) ? phones.cord : [],
            'internetState': swc.models.Network.getParameter('ConnectionStatus', 'status'),
            'wiredState': true, // This value is hardcoded cause no posibility to check status
            'dectState': swc.models.Telephony.get('dectStatus'),
            'centralStorageState': swc.models.CentralStorage.getParameter("status", "status"),
            'IPv6Address': swc.models.Network.getParameter('IPv6Address',  'status'),
            'GlobalEnable': swc.models.Application.get('GlobalEnable'),
            'wifiState': swc.models.Wireless.getParameter("status", "status"),
            'wifiSchedulerState': swc.models.Schedulers.get('wifi').get('enable'),
            'cloudService': cloud
        };
    },

    renderComplete: function() {
        var self = this;

        // Set listener on Network State change:
        swc.models.Network.on('change', function() {
            self.updateInternetState();
            self.updateGatewayState();
        });

        // Set listener on Backup stick change:
        swc.models.InternetBackupStick.on('change', function() {
            self.updateInternetState();
            self.updateGatewayState();
            self.renderUSBDevices();
        });

        // Set Listener on Central Storage manager change:
        swc.models.CentralStorage.on('central-storage-update', function() {
            self.updateCentralStorageState();
            self.renderUSBDevices();
        });

        swc.models.CloudAccountCollection.on('change', function() {
            self.updateCloudState();
        });

        // Set Listener on WiFi manager change:
        swc.models.Wireless.on('change', function() {
            self.updateWirelessState();
        });

        // Set Listener on Telephony manager change:
        swc.models.Telephony.on('change', function() {
            self.updatePhonesState();
            self.renderDECTDevices();
        });

        // Set Listener on WAN Device manager change:
        swc.models.NetworkDevices.on('devices-loaded', function() {
            self.updateNetworkState();
            self.renderNetworkDevices();
        });

        // Set default states:
        this.updateInternetState();
        this.updateGatewayState();
        this.updateNetworkState();
        this.updateCloudState();
        this.updatePhonesState();
        this.updateCentralStorageState();
        this.updateWirelessState();

        // Render devices:
        this.renderNetworkDevices();
        this.renderUSBDevices();
        this.renderDECTDevices();
    },

    updateInternetState: function() {
        var connection = this.$el.find('.connection.internet'),
            connectionState = connection.hasClass('disconnected') ? false : true,
            connectionData = {
                "status": swc.models.Network.getParameter('ConnectionStatus', 'status'),
                "LTEmodemStatus": swc.models.InternetBackupStick.get('isConnected'),
                "localIPAddress" : swc.models.Network.getParameter('LocalIPAddress',  'ip-settings'),
                "remoteIPAddress": swc.models.Network.getParameter('RemoteIPAddress', 'status'),
                "connectionType" : swc.models.Network.getParameter('ConnectionType',  'status'),
                "lastConnection" : swc.models.Network.getParameter('LastConnection',  'status'),
                "deviceName"     : swc.models.Network.getParameter('DeviceName',      'status')
            },
            elementData = connection.data('popover-template-data'),
            elementDataChanged = this.checkElementDataChanged(elementData, connectionData);

        // Set visual connection updates
        connection.toggleClass('disconnected', !connectionData.status);
        connection.toggleClass('LTEmodemConnected', connectionData.LTEmodemStatus);

        // Update popover information if something was changed to current element:
        if (elementDataChanged || connectionState !== connectionData.status) {
            this.updateConnectionsData(connection, connectionData);
            this.updateConnectionsPopover(connection);
        }
    },

    updateGatewayState: function() {
        var connection = this.$el.find('.connection.gateway'),
            connectionState = connection.hasClass('disconnected') ? false : true,
            IPv6Address = swc.models.Network.getParameter('IPv6Address',  'status'),
            connectionData = {
                "status": swc.models.Network.getParameter('ConnectionStatus', 'status'),
                "localIPAddress"  : swc.models.Network.getParameter('LocalIPAddress',  'ip-settings'),
                "remoteIPAddress" : swc.models.Network.getParameter('RemoteIPAddress', 'status'),
                "storageIPAddress": swc.models.Network.getParameter('StorageIPAddress', 'status'),
                "connectionType"  : swc.models.Network.getParameter('ConnectionType',  'status'),
                "lastConnection"  : swc.models.Network.getParameter('LastConnection',  'status'),
                'IPv6Address'     : IPv6Address,
                "deviceName"      : swc.models.Network.getParameter('DeviceName',      'status'),
                "GlobalEnable"   : swc.models.Application.get('GlobalEnable')
            },
            elementData = connection.data('popover-template-data'),
            elementDataChanged = this.checkElementDataChanged(elementData, connectionData);

        // Set visual connection updates
        connection.toggleClass('disconnected', !connectionData.status);

        // Update popover information if something was changed to current element:
        if (elementDataChanged || connectionState !== connectionData.status) {
            this.updateConnectionsData(connection, connectionData);
            this.updateConnectionsPopover(connection);
        }
    },

    updateNetworkState: function() {
        var connection = this.$el.find('.connection.wired'),
            connectionState = connection.hasClass('disconnected') ? false : true,
            connectionData = {
                "status": true,
                "wiredDevicesCount": swc.models.NetworkDevices.countWiredConnectedDevices()
            },
            elementData = connection.data('popover-template-data'),
            elementDataChanged = this.checkElementDataChanged(elementData, connectionData);

        // Set visual connection updates
        connection.toggleClass('disconnected', !connectionData.status);

        // Update popover information if something was changed to current element:
        if (elementDataChanged || connectionState !== connectionData.status) {
            this.updateConnectionsData(connection, connectionData);
            this.updateConnectionsPopover(connection);
        }
    },

    updateCloudState: function() {
        var connection = this.$el.find('.connection.cloud'),
            connectionState = connection.hasClass('disconnected') ? false : true,
            elementData = connection.data('popover-template-data'),
            models = swc.models.CloudAccountCollection.models,
            cloud = !_.isEmpty(models) ? models[0].getExtendedJSON() : '',
            connectionData = {
                'status': !!cloud,
                "centralStorageStatus": swc.models.CentralStorage.getParameter("status", "status"),
                'internetStatus': swc.models.Network.getParameter('ConnectionStatus', 'status'),
                'cloudService': cloud
            },
            elementDataChanged = this.checkElementDataChanged(elementData, connectionData),
            status = connectionData.cloudService.status,
            error = connectionData.cloudService.error,
            credentialsProblem = status === 'ERROR' && error === 'INVALID_CREDENTIALS',
            isError = (status === 'ERROR' && error === 'INVALID_CREDENTIALS') || status === 'STORAGE_DISCONNECTED',
            isWarning = status === 'ERROR' && error !== 'INVALID_CREDENTIALS';

        // Set visual connection updates
        if (!connectionData.cloudService.status) {
            connection.addClass('disconnected');
        } else {
            connection.removeClass('disconnected');
            connection.toggleClass('credentialsProblem', credentialsProblem);
            connection.toggleClass('complete', status === 'COMPLETE');
            connection.toggleClass('synching', status === 'IN_PROGRESS');
            connection.toggleClass('warning', status === 'ERROR');
            connection.toggleClass('error', status === 'STORAGE_DISCONNECTED');

            // Set current service to visible state:
            connection.find('.cloud-service').addClass('hidden');
            connection.find('.' + connectionData.cloudService.id + '-account').removeClass('hidden');
        }

        // Update popover information if something was changed to current element:
        if (elementDataChanged || connectionState !== connectionData.status) {
            this.updateConnectionsData(connection, connectionData);
            this.updateConnectionsPopover(connection);
        }
    },

    updatePhonesState: function() {
        var phones = swc.models.Telephony.getPhonesList(),
//            phoneLines = swc.models.Telephony.get('voip') ? swc.models.Telephony.get('voip').where({'enable': 'Enabled'}) : [],
            dectStatus = swc.models.Telephony.get('dectStatus'),
            voipStatus = swc.models.Telephony.get('voipStatus'),
            connection = this.$el.find('.connection.phones'),
            connectionPortOne = this.$el.find('.list.phones .static-phone-1'),
            connectionPortTwo = this.$el.find('.list.phones .static-phone-2'),
            connectionState = connection.hasClass('disconnected') ? false : true,
            connectionData = {
                "dectStatus": dectStatus,
                "voipStatus": voipStatus,
                "port-1": {
                    "status": voipStatus && (!_.isEmpty(phones.cord[0]) && _.isBoolean(phones.cord[0].isDisabled) && !phones.cord[0].isDisabled),
                    "number": 1,
                    "numbers":  {
                        "internal": !_.isEmpty(phones.cord[0]) ? phones.cord[0].internalNumber : '',
                        "external": !_.isEmpty(phones.cord[0]) ? phones.cord[0].externalNumber : ''
                    }
                },
                "port-2": {
                    "status": voipStatus && (!_.isEmpty(phones.cord[1]) && _.isBoolean(phones.cord[1].isDisabled) && !phones.cord[1].isDisabled),
                    "number": 2,
                    "numbers":  {
                        "internal": !_.isEmpty(phones.cord[1]) ? phones.cord[1].internalNumber : '',
                        "external": !_.isEmpty(phones.cord[1]) ? phones.cord[1].externalNumber : ''
                    }
                }
            },
            elementData = connection.data('popover-template-data'),
            elementDataChanged = this.checkElementDataChanged(elementData, connectionData);

        // Set visual connection updates
        connection.toggleClass('disconnected', !connectionData.dectStatus);
        
        // Add class to mark connection as partially connected
        connection.toggleClass('partially', connectionData.voipStatus);

        // Set phone ports connection state:
        connectionPortOne.toggleClass('disconnected', !connectionData["port-1"].status);
        connectionPortTwo.toggleClass('disconnected', !connectionData["port-2"].status);

        // Update popover information if something was changed to current element:
        if (elementDataChanged || connectionState !== connectionData.status) {
            this.updateConnectionsData(connection, connectionData);
            this.updateConnectionsData(connectionPortOne, connectionData["port-1"]);
            this.updateConnectionsData(connectionPortTwo, connectionData["port-2"]);

            this.updateConnectionsPopover(connection);
            this.updateConnectionsPopover(connectionPortOne);
            this.updateConnectionsPopover(connectionPortTwo);
        }
    },

    updateCentralStorageState: function() {
        var connection = this.$el.find('.connection.usb'),
            connectionState = connection.hasClass('disconnected') ? false : true,
            connectionData = {
                "status": swc.models.CentralStorage.getParameter("status", "status") && swc.models.Application.get('GlobalEnable'),
                "usbDevicesCount": swc.models.CentralStorage.getParameter("devices", "usb-devices").length,
                "mediaServerStatus": swc.models.CentralStorage.getParameter("mediaServerStatus", "status"),
                "GlobalEnable": swc.models.Application.get("GlobalEnable")
            },
            elementData = connection.data('popover-template-data'),
            elementDataChanged = this.checkElementDataChanged(elementData, connectionData);

        // Set visual connection updates
        connection.toggleClass('disconnected', !connectionData.status);

        // Update popover information if something was changed to current element:
        if (elementDataChanged || connectionState !== connectionData.status) {
            this.updateConnectionsData(connection, connectionData);
            this.updateConnectionsPopover(connection);
        }
    },

    updateWirelessState: function() {
        var connection = this.$el.find('.connection.wifi'),
            connectionState = connection.hasClass('disconnected') ? false : true,
            connectionData = {
                "status": swc.models.Wireless.getParameter("status", "status") === "on",
                "wifiSchedulerState": swc.models.Schedulers.get('wifi').get('enable'),
                "wifiCombinedMode": swc.models.Wireless.getParameter("configurationMode", "status"),
                "wifi24GHzName":   swc.models.Wireless.getParameter("name", "2.4GHz"),
                "wifi24GHzStatus": swc.models.Wireless.getParameter("status", "2.4GHz"),
                "wifi5GHzName":    swc.models.Wireless.getParameter("name", "5GHz"),
                "wifi5GHzStatus":  swc.models.Wireless.getParameter("status", "5GHz"),
                "wifiGuestName":   swc.models.Wireless.getParameter("name", "Guest-2.4GHz"),
                "wifiGuestStatus": swc.models.Wireless.getParameter("status", "guestStatus")
            },
            elementData = connection.data('popover-template-data'),
            elementDataChanged = this.checkElementDataChanged(elementData, connectionData);

        // Set visual connection updates
        connection.toggleClass('disconnected', !connectionData.status);

        // Update popover information if something was changed to current element:
        if (elementDataChanged || connectionState !== connectionData.status) {
            this.updateConnectionsData(connection, connectionData);
            this.updateConnectionsPopover(connection);
        }
    },

    updateConnectionsPopover: function(connection) {
        if (connection.hasClass('selected')) {
            SWCElements.popovers.open(connection.find('.icon'));
        }
    },

    updateConnectionsData: function(element, connectionData) {
        var prefix = element.hasClass('disconnected') ? 'disconnected' : 'connected';

        element.data({
            "popover-template-id": "overview:popovers:" + element.data('type') + "-" + prefix,
            "popover-element": ".icon",
            "popover-placement": "left",
            "popover-holder": ".connection." + element.data("type"),
            "popover-container": ".current-page .overview",
            "popover-template-data": connectionData
        });
    },

    checkElementDataChanged: function(elementData, newData) {
        var elementDataChanged = false;

        if (!elementData) {
            elementDataChanged = true;
        } else {
            $.each(newData, function(key, value) {
                if (!typeof(elementData[key])) {
                    elementDataChanged = true;
                } else {
                    if (elementData[key] !== value) {
                        elementDataChanged = true;
                    }
                }
            });
        }

        return elementDataChanged;
    },

    renderNetworkDevices: function() {
        var NetworkDevices = swc.models.NetworkDevices.getConnectedDevices(),
            DHCPLeases = _.pluck(swc.models.DHCPLeases.getActiveLeases(), 'MACAddress'),
            template = swc.Templates.get("components:device").get('content'),
            disconnected = { "wired": 0, "wireless": 0 },
            activeDevicePhysAddress,
            self = this;

        // Fill in WAN Devices List:
        $.each(NetworkDevices, function(connectionType, devicesArray) {
            var list = self.$el.find('.devices-list .list.' + connectionType),
                selectedDevice = list.find('.device.has-popover.selected');

            // Check if any device has popover on it
            if (selectedDevice.size()) {
                activeDevicePhysAddress = selectedDevice.data('macaddress');
                SWCElements.popovers.closeAll();
            }

            // Remove old devices:
            list.find('.device').remove();

            if (!NetworkDevices[connectionType].length) {
                list.find('.no-devices').show();
            } else {
                list.find('.no-devices').hide();
            }
            
            // Render devices
            $.each(devicesArray, function(key, device) {
                var templatePrefix = device.status ? 'connected' : 'disconnected';

                // Only 10 not connected devices must be shown to the user:
                if (!device.status && disconnected[device.interfaceType] >= 10) {
                    return;
                }
                if( _.contains(DHCPLeases, device.mac)) {
                   device.address['static'] = true;
                }
                // Set correct length of device name:
                device.nameShort = self.stripDeviceName(device.name);
                device.IPv6Enabled = swc.models.FirewallStatus.get('state').Enable;

                // All IPv6 Addresses have to be displayed in short form:
                // Display only global IPv6 addresses on overview page if they are present. 
                // If only link scope address present, display link scope address
                if (device.addressObjects.IPv6.length) {
                    device.address.IPv6 = [];
                    $.each(device.addressObjects.IPv6, function(key, address) {
                        // Show only Global IPv6 address on Overview page
                        if (address.scope === "global") {
                            device.address.IPv6[key] = swc.Utils.formatIPv6Address(address.ipAddress);
                        }
                    });
                }
                
                // Append device to the list:
                list.append(
                    $.tmpl(template, {
                        device: device,

                        className: device.status ? 'connected' : 'disconnected',

                        popoverEnable: true,
                        popoverTemplateID: 'overview:popovers:device-' + templatePrefix,
                        popoverTemplateData: JSON.stringify(device),
                        popoverContainer: '.current-page .overview',

                        lastInRow: (key + 1) % 3 === 0 ? "last-in-row" : "" // Need to make a moving to new line in template
                    })
                );
            });

            // Reopen popover for selected device:
            if (activeDevicePhysAddress && activeDevicePhysAddress.length) {
                SWCElements.popovers.open(
                    $('.device.has-popover[data-macaddress="' + activeDevicePhysAddress + '"]').find('.icon')
                );
            }
        });
    },

    renderUSBDevices: function() {
        var usbDevices = !swc.models.Application.get('GlobalEnable') ? [] : swc.models.CentralStorage.getParameter("devices", "usb-devices"),
            template = swc.Templates.get("components:device-storage").get('content'),
            list = this.$el.find('.devices-list .list.usb'),
            selectedDevice = list.find('.device.has-popover.selected'),
            activeDeviceID = selectedDevice.size() ? selectedDevice.data('usbid') : 0,
            emergencyStick = swc.models.InternetBackupStick,
            supportedUsbDevices = _.keys(swc.settings.application.get('supportedUsbDevices'));

        // Check if any device has popover on it
        if (selectedDevice.size()) {
            SWCElements.popovers.closeAll();
        }

        // Remove old devices:
        list.find('.device').remove();

        // Check if devices exists:
        if (!usbDevices.length && !emergencyStick.get('isConnected')) {
            list.find('.no-devices').show();
        } else {
            list.find('.no-devices').hide();
        }

        // Check if emergency stick is active:
        if (emergencyStick.get('isConnected')) {
            var device = _.extend(emergencyStick.toJSON(), {
                cloudServicesState: swc.models.СloudServicesStatus.get('isEnabled')
            });

            list.append(
                $.tmpl(swc.Templates.get("components:device-emergency").get('content'), {
                    device: device,

                    popoverEnable: true,
                    popoverTemplateID: 'overview:popovers:device-emergency',
                    popoverTemplateData: JSON.stringify(_.extend(device, { cloudServicesState: false })),
                    popoverContainer: '.current-page .overview',
                    localeStrings: swc.models.Locale.getLocaleStrings(),
                    localeString: getTranslationStringsjQuery,
                    formatDate: swc.models.Locale.formatDate
                })
            );
        }

        // Append devices to the list:
        $.each(usbDevices, function(key, device) {
            var prefix = device.type === "usb-disk-undefined" ? "-unsupported" : "",
                deviceIsSupported = ($.inArray(device.type.toLowerCase(), supportedUsbDevices) !== -1);

            // Extend device object with new properties:
            device = _.extend(device, {
                cloudServicesState: swc.models.СloudServicesStatus.get('isEnabled')
            });

            list.append(
                $.tmpl(template, {
                    device: device,
                    deviceIsSupported: deviceIsSupported,
                    popoverEnable: true,
                    popoverTemplateID: 'overview:popovers:device-storage' + prefix,
                    popoverTemplateData: JSON.stringify(device),
                    popoverContainer: '.current-page .overview',
                    localeStrings: swc.models.Locale.getLocaleStrings(),
                    localeString: getTranslationStringsjQuery,
                    formatDate: swc.models.Locale.formatDate
                })
            );
        });

        // Reopen popover for selected device:
        if (activeDeviceID) {
            SWCElements.popovers.open(
                $('.device.has-popover[data-usbid="' + activeDeviceID + '"]').find('.icon')
            );
        }
    },

    renderDECTDevices: function() {
        var dectDevices = swc.models.Telephony.get('phones').where({deviceType:'dect'}),
            template = swc.Templates.get("components:device-dect").get('content'),
            list = this.$el.find('.devices-list .dect-devices'),
            selectedDevice = list.find('.device.has-popover.selected'),
            activeDeviceID = selectedDevice.size() ? selectedDevice.data('dectid') : 0;

        // Check if any device has popover on it
        if (selectedDevice.size()) {
            SWCElements.popovers.closeAll();
        }

        // Remove old devices:
        list.find('.device').remove();

        // Check if devices exists and DECT is On:
        if (!dectDevices.length || !swc.models.Telephony.get('dectStatus')) {
            list.find('.no-devices').show();
            return;
        } else {
            list.find('.no-devices').hide();
        }

        // Append devices to the list:
        $.each(dectDevices, function(key, device) {
            var data = {
                id: device.get('id'),
                icon: 'dect',
                name: device.get('name'),
                line: device.get('line'),
                nameDisplay: device.get('name'), // discussed with Marcel, no need to make lowercase
                phoneNumber: device.get('externalNumber'),
                internalNumber: device.get('directoryNumber'),
                outgoingTrunkLine: device.get('outgoingTrunkLine')
            };

            list.append(
                $.tmpl(template, {
                    device: data,
                    popoverEnable: true,
                    popoverTemplateID: 'overview:popovers:device-dect',
                    popoverTemplateData: JSON.stringify(data),
                    popoverContainer: '.current-page .overview',
                    localeStrings: swc.models.Locale.getLocaleStrings(),
                    localeString: getTranslationStringsjQuery,
                    formatDate: swc.models.Locale.formatDate
                })
            );
        });

        // Reopen popover for selected device:
        if (activeDeviceID) {
            SWCElements.popovers.open(
                $('.device.has-popover[data-dectid="' + activeDeviceID + '"]').find('.icon')
            );
        }
    },

    setWiFiState: function(e) {
        var self = this,
            switcher = $(e.target).hasClass('.swc-switcher') ? $(e.target) : $(e.target).closest('.swc-switcher'),
            state = switcher.hasClass('enable') ? true : false;

        // Set small delay on switcher change for more user-friendly behaviour
        setTimeout(function() {

            // Show saving page state:
            self.showPageLoading("Updating WiFi state");

            // Send requests to update wifi status on the device:
            $.when(
                    swc.models.Wireless.setGlobalStatus(state)
                ).done(function() {
                    self.render();
                });
        }, 200);
    },

    setCentralStorageState: function(e) {
        var self = this,
            switcher = $(e.target).hasClass('.swc-switcher') ? $(e.target) : $(e.target).closest('.swc-switcher'),
            state = switcher.hasClass('enable') ? true : false;

        // Set small delay on switcher change for more user-friendly behaviour
        setTimeout(function() {

            // Show saving page state:
            self.showPageLoading("Updating Central Storage state");

            // Send requests to update Central Storage status on the device:
            $.when(
                    swc.models.CentralStorage.setGlobalStatus(state)
                ).done(function() {
                    self.render();
                });
        }, 200);
    },

    setDECTState: function(e) {
        var self = this,
            switcher = $(e.target).hasClass('.swc-switcher') ? $(e.target) : $(e.target).closest('.swc-switcher'),
            state = switcher.hasClass('enable') ? true : false;

        // Set small delay on switcher change for more user-friendly behaviour
        setTimeout(function() {

            // Show saving page state:
            self.showPageLoading("Updating Phones and Dect state");

            // Update Telephony model Dect status:
            swc.models.Telephony.set('dectStatus', state);

            // Send requests to update Telephony status on the device:
            $.when(
                    swc.models.Telephony.setDectStatus()
                ).done(function() {
                    self.render();
                });
        }, 200);
    },

    editDevice: function(e) {
        var self = this,
            element = $(e.target),
            type = element.data('type'),
            macAddress = element.data('macaddress'),
            device = swc.models.NetworkDevices.getDevice(macAddress);

        this.customizeDevice({
            device: device,
            type: type,

            onApply: function(options) {
                self.showPageLoading("Updating device information");

                $.when(swc.models.NetworkDevices.customizeDevice(options)).done(function() {
                    $.when(swc.models.NetworkDevices.sync()).done(function() {
                        self.updateNetworkState();
                        self.renderNetworkDevices();
                        self.stopPageLoading();
                    });

                    SWCElements.popovers.open(
                        $('.device[data-macaddress="' + options.deviceMac + '"]').find('.icon')
                    );
                });
            }
        });
    },

    editDect: function(e) {
        var self = this,
            element = $(e.target),
            name = element.data('name'),
            line = element.data('line'),
            device = {
                type: 'dect',
                name: name,
                line: line
            };

        this.customizeDevice({
            device: device,
            type: 'dect',
            template: 'overview:modal-windows:customize-dect',

            onApply: function(options) {

                self.showPageLoading("Updating device information");

                swc.models.Telephony.get('phones').get(line).set({
                    'name': options.name,
                    'is_changed': true
                });

                $.when(swc.models.Telephony.phoneEdit()).done(function(){
                    $.when(swc.models.Telephony.getPhones()).done(function() {
                        self.renderDECTDevices();
                        self.stopPageLoading();
                    });

                    SWCElements.popovers.open(
                        $('.device.has-popover[data-dectid="' + line + '"]').find('.icon')
                    );
                });
            }
        });
    },

    secureRemoveUSB: function(e) {
        var self = this,
            button = $(e.target).hasClass('.button') ? $(e.target) : $(e.target).closest('.button'),
            id = button.data('id');

        // Set small delay on switcher change for more user-friendly behaviour
        setTimeout(function() {

            // Show saving page state:
            self.showPageLoading("Unmounting usb device");

            // Send requests to update Telephony status on the device:
            $.when(
                    swc.models.CentralStorage.removeUSBDevice(id)
                ).done(function() {
                    self.render();
                });
        }, 200);
    },

    loginToCloudService: function(e) {
        var self = this,
            button = $(e.target).hasClass('.button') ? $(e.target) : $(e.target).closest('.button'),
            service = button.hasClass('dropbox') ? 'dropbox' : 'googledrive';

        // Login to selected cloud service:
        swc.models.CloudServices.checkCredentials();
    }
});
