swc.constructors.NetworkSettingsPortforwardingView = swc.base.TabView.extend({

    className: 'port-forwarding',

    allowedMods: [
        'expert'
    ],

    events: {
        'click .expandable-list .trash.process-delete:not(.disabled)': 'deleteRule',
        'click .expandable-list .pencil.process-edit:not(.disabled)': 'editRule',

        'swc-checkbox:change .swc-checkbox.upnp': 'setUPnPStatus',
        'swc-checkbox:change .swc-checkbox.enable-rule': 'setRuleStatus'
    },

    models: [
        'UPnP',
        'PortForwarding',
        'NetworkDevices'
    ],

    pageUrl: 'network/settings/port-forwarding',

    setTemplateData: function() {
        var rules = swc.models.PortForwarding.toJSON();

        // Get device name by ip from rule:
        _.each(rules, function(rule, key) {
            var device = swc.models.NetworkDevices.getDeviceByIP(rule.deviceIP);

            /**
             * NP returns IP address of Assigned Device. And there can be a situation that device IP was changed, or
             * device was not connected to the NP during last 10 days. So assigned IP for rule will refer to nowhere,
             * because such device will no longer exist in NP base.
             */
            if (!_.isUndefined(device)) {
                rule.deviceName = device.get('name');
            } else {
                rule.deviceName = "n/a";
            }
        });

        this.templateData = {
            upnpStatus: swc.models.UPnP.get('status'),
            rules: rules
        };
    },

    setUPnPStatus: function(e, upnpStatus) {
        swc.models.UPnP.set('status', upnpStatus);

        // Update buttons state to see, that upnp has been changed
        this.setButtonsState();
    },

    deleteRule: function(e, value) {
        var parameter = getParameter($(e.target)),
            ruleID = parameter.parameterData.rule.toString(),
            ruleItem = this.$('.expandable-list-item[data-key="' + ruleID + '"]'),
            model = swc.models.PortForwarding.findWhere({ id: ruleID });

        // Update model in the collection:
        swc.models.PortForwarding.remove(model);

        // Remove item from the list
        ruleItem.remove();

        // Update buttons state to see, that rule have been deleted
        this.setButtonsState();
    },

    setRuleStatus: function(e, value) {
        var parameter = getParameter($(e.target)),
            ruleID = parameter.parameterData.rule.toString(),
            model = swc.models.PortForwarding.findWhere({ id: ruleID });

        // Update model in the collection:
        model.set('status', value);

        // Update buttons state to see, that rule have been deleted
        this.setButtonsState();
    },

    pageCheckDefaultValues: function() {

        // BAD BAD BAD FIXME :: fix this when we will have same handling in all views
        this.parentView.pageCheckDefaultValues = function() {
            return !swc.models.UPnP.hasChanged() && !swc.models.PortForwarding.hasChanged();
        };

        return !swc.models.UPnP.hasChanged() && !swc.models.PortForwarding.hasChanged();
    },

    editRule: function(e, value) {
        var parameter = getParameter($(e.target));

        // This is done to get Rule on edit page
        localStorage.setItem('port-forwarding:edit-ruleID', parameter.parameterData.rule);

        swc.router.navigate(this.pageUrl + '/edit', { trigger: true });
    },

    save: function() {
        var self = this,
            deferred = new $.Deferred(),
            toDo = [
                swc.models.UPnP.sync('update')
            ],
            deletedRules = swc.models.PortForwarding.changedModels({ onlyDeleted: true  }),
            changedRules = swc.models.PortForwarding.changedModels({ onlyEdited: true  });

        _.each(deletedRules, function(model, key) {
            toDo.push(
                model.sync('delete'),
                model.sync('commit')
            );
        });

        _.each(changedRules, function(model, key) {
            toDo.push(
                model.sync('update'),
                model.sync('commit')
            );
        });

        $.when.apply(this, toDo)
            .done(function() {
                deferred.resolve();
            })
            .fail(function() {
                deferred.reject();
            });

        return deferred.promise();
    }

});