swc.constructors.NetworkSettingsPortforwardingEditView = swc.constructors.NetworkSettingsPortforwardingAddView.extend({

    className: 'port-forwarding-edit',

    events: {
        'swc-radio-buttons:change .swc-radio-buttons.entry-mode': 'setEntryPortMode',
        'swc-radio-buttons:change .swc-radio-buttons.destination-mode': 'setDestinationPortMode',

        'change input[name="entryPort"].from': 'updateDestinationPorts',
        'change input[name="entryPort"].to': 'updateDestinationPorts'
    },

    setTemplateData: function() {
        var rule = swc.models.PortForwarding.findWhere({ id: localStorage.getItem('port-forwarding:edit-ruleID') }),
            device, ports;

        // Rule is not existing. Impossible situation:
        if (_.isUndefined(rule)) {
            swc.router.navigate('network/settings/port-forwarding', { skipUnsavedChanges: true });
            return;
        }

        // Catch current model for future work with it:
        this.model = rule;

        // Check if device with current IP exists in NP db
        device = swc.models.NetworkDevices.getDeviceByIP(rule.get('deviceIP'));

        this.templateData = {
            name: rule.get('name'),
            id: rule.get('id'),
            port: {
                entry: rule.get('ports').entry,
                destination: rule.get('ports').destination
            },
            portMode: {
                entry: rule.get('ports').entry.length === 2 ? "range" : "single",
                destination: rule.get('ports').destination.length === 2 ? "range" : "single"
            },
            device: !_.isUndefined(device) ? rule.get('deviceIP') : "0.0.0.0",
            protocol: rule.get('protocol')
        };
    },

    /**
     * @override on {'swc.BaseView.initialize()'} method
     *
     * Need to set new template in order to support /1/2/3/4/.../n/ lvls of views including.
     *
     * @returns {boolean}
     */
    initialize: function() {
        // Prepare template for current page:
        this.template = $.template("pageContent", swc.Templates.get('network:settings:port-forwarding:rules-edit').get('content'));

        // Extend global events:
        this.events = _.extend(
            swc.constructors.NetworkSettingsPortforwardingAddView.prototype.events,
            swc.base.PageView.prototype.events,
            this.events
        );
    },

    save: function() {
        var self = this,
            deferred = new $.Deferred(),
            updatedModel = this.updateRuleModel();

        // NP requires commit action after any changes done to rules:
        $.when(updatedModel.sync('update'))
            .done(function() {
                swc.router.navigate('network/settings/port-forwarding', { skipUnsavedChanges: true });
                deferred.resolve();
            })
            .fail(function() {
                deferred.reject();
            });

        return deferred.promise();
    }

});
