swc.constructors.NetworkSettingsIpv6firewallView = swc.base.TabView.extend({

    className: 'ipv6-firewall',

    allowedMods: ['expert'],

    events: {
        "click .button-customize:not(.disabled)": "customizeFirewall",
        "swc-radio-buttons:change .security-selection": "setCustomizeButtonState",
        "swc-checkbox:change .IPv6Enable" : "changeFirewallState"
    },

    models:[
        'FirewallStatus'
    ],

    validation:{
        "RuleName":"FirewallCustomRules:RuleName",
        "DestinationPortsRange": "FirewallCustomRules:DestinationPortsRange"
    },
    
    hasChanged: function() {
        return !this.pageCheckDefaultValues();
    },

    setTemplateData: function() {
        var firewallModel = swc.models.FirewallStatus,
            posibleLevels =  _.invert(firewallModel.possibleStatus);

        this.templateData = {
            IPv6Status: firewallModel.get("state").Enable,
            securityLevel: posibleLevels[firewallModel.get('status')]
        };
    },

    customizeFirewall: function() {
        if (!this.hasChanged()) {
            swc.router.navigate('network/settings/ipv6-firewall/customize', { skipUnsavedChanges: true });
        } else {
            $.when(this.save())
                .done(function() {
                    swc.router.navigate('network/settings/ipv6-firewall/customize', { skipUnsavedChanges: true });
                });
        }
    },

    setCustomizeButtonState: function(e, policyState) {
        this.$('.button-customize').toggleClass('disabled', policyState !== "custom");
    },

    changeFirewallState: function(e, value) {
        var selectedLevelRadio = this.$(".swc-radio-buttons .mode.active");
        
        swc.models.FirewallStatus.set('state', {"Enable": value});
        this.$('.security-selection').toggleClass('disabled', !value);
        
        if (!value || (value && selectedLevelRadio.data("value") !== "custom")) {
            this.$('.button-customize').addClass('disabled');
        } else if (value && selectedLevelRadio.data("value") === "custom"){
            this.$('.button-customize').removeClass('disabled');
        }
    },

    save: function() {
        var self = this,
            deferred = new $.Deferred(),
            pageData = [],
            actionsToDo = [];

        // Get elements name => value map
        $.each(this.getElements(), function(key, element) {
            pageData.push(getParameter($(element)));
        });

        actionsToDo = [
            swc.models.FirewallStatus.saveSettedLevel(pageData),
            swc.models.FirewallStatus.saveFirewallState(pageData)
        ];

        // Process save request:
        $.when.apply(null, actionsToDo)
            .done(function() {
                return deferred.resolve();
            })
            .fail(function() {
                return deferred.reject();
            });

        return deferred.promise();
    }
});
