swc.constructors.NetworkSettingsIpv6firewallCustomizeView = swc.base.TabView.extend({

    className: 'ipv6-firewall-rules-list',

    allowedMods: ['expert'],

    events: {
        'click .expandable-list .trash.process-delete:not(.disabled)': 'deleteRule',
        'click .expandable-list .pencil.process-edit:not(.disabled)': 'editRule',

        'swc-checkbox:change .swc-checkbox.enable-service': 'setRuleState'
    },

    models:[
        'FirewallPolicy',
        'FirewallRules'
    ],

    rulesToDelete: [],

    rulesToChangeState: {},

    setTemplateData: function() {
        var firewallRules = swc.models.FirewallRules.toJSON();

        this.templateData = {
            rules: firewallRules,
            rulesArrayLength: getObjectLength(firewallRules)
        };
    },

    initialize: function() {
        // Prepare template for current page:
        this.template = $.template("pageContent", swc.Templates.get('network:settings:ipv6-firewall:rules-list').get('content'));

        // Extend global events:
        this.events = _.extend({}, swc.base.PageView.prototype.events, this.events);
    },

    renderComplete: function() {
        var policyOptions = swc.models.FirewallPolicy.formatPolicyOptions(),
            policyValue = swc.models.FirewallPolicy.getValue(),
            dropdownPolicy = this.$el.find('.swc-dropdown.policy-selection'),
            isRuleActionSuccess = localStorage.getItem('firewall:change-rule');

        // Display rule saving success or fail message:
        if (!_.isNull(isRuleActionSuccess)) {
            this.showSaveSuccess(isRuleActionSuccess === "done" ? 'success' : 'error', true);
            localStorage.removeItem('firewall:change-rule');
        }

        this.fillDropdown(dropdownPolicy, policyOptions, policyValue);
    },

    fillDropdown: function(dropdown, data, selected) {
        for (var defaultAction in data) {
            break;
        }

        dropdown.data('options', data);

        if (selected) {
            dropdown.data('default-value', selected);
            dropdown.trigger('swc-dropdown:swc-change', selected);
        } else {
            dropdown.data('default-value', defaultAction);
            dropdown.trigger('swc-dropdown:swc-change', defaultAction);
        }
    },

    deleteRule: function(e, value) {
        var parameter = getParameter($(e.target)),
            ruleID = parameter.parameterData.rule.toString(),
            ruleItem = this.$el.find('.expandable-list-item[data-key="' + ruleID + '"]'),
            storage = this.$el.find('input[name="rules-to-delete"]');

        this.rulesToDelete.push(ruleID);

        // The only way for now to handle deletion change on the page
        storage.val('action-happened');

        // Remove this from list of changed state rules (anyway it will be deleted)
        if (this.rulesToChangeState[ruleID]) {
            delete this.rulesToChangeState[ruleID];
        }

        // Remove item from the list
        ruleItem.remove();

        // Update buttons state to see, that rule have been deleted
        this.setButtonsState();
    },

    setRuleState: function(e, value) {
        var parameter = getParameter($(e.target)),
            ruleID = parameter.parameterData.rule.toString(),
            storage = this.$el.find('input[name="rules-to-delete"]');

        // The only way for now to handle editing of custom change on the page
        if (value !== parameter.parameterData.defaultValue) {
            this.rulesToChangeState[ruleID] = {
                value: value
            };
        } else {
            if (this.rulesToChangeState[ruleID]) {
                delete this.rulesToChangeState[ruleID];
            }
        }
    },

    editRule: function(e, value) {
        var parameter = getParameter($(e.target));

        localStorage.setItem('firewal:edit-ruleID', parameter.parameterData.rule);

        swc.router.navigate('network/settings/ipv6-firewall/edit', { trigger: true });
    },

    /**
     * @override
     * @description:
     *
     *  Display message from editing / adding rules:
     */
    showSaveSuccess: function(type, isFromRulePage) {
        var messageNew = this.$('.buttons-container-message .save-' + (type || 'success'));

        // Hide previous messages:
        this.$('.buttons-container-message .save-error').hide();
        this.$('.buttons-container-message .save-success').hide();

        // Defined what message to show:
        if (!_.isUndefined(isFromRulePage)) {
            messageNew = messageNew.filter('.from-rule');
        } else {
            messageNew = messageNew.filter(':not(.from-rule)');
        }

        messageNew.show();
    },

    save: function() {
        var self = this,
            deferred = new $.Deferred(),
            deferredActions = [],
            pageData = [];

        // Get elements name => value map
        $.each(this.getElements(), function(key, element) {
            pageData.push(getParameter($(element)));
        });

        // Create list of actions to be done:
        deferredActions = [
            swc.models.FirewallRules.updateRulesList(self.rulesToChangeState, self.rulesToDelete),
            swc.models.FirewallPolicy.setValue(pageData)
        ];

        $.when.apply(null, deferredActions)
            .done(function() {
                deferred.resolve();
            })
            .fail(function() {
                deferred.reject();
            });

        return deferred.promise();
    }
});
