swc.constructors.NetworkSettingsIpv6firewallEditView = swc.constructors.NetworkSettingsIpv6firewallAddView.extend({

    initialize: function() {
        this.template = $.template("pageContent", swc.Templates.get('network:settings:ipv6-firewall:rules-edit').get('content'));
        this.events = _.extend({}, swc.base.PageView.prototype.events, this.events);
    },

    setTemplateData: function() {
        var ruleID = localStorage.getItem('firewal:edit-ruleID'),
            rule = swc.models.FirewallRules.get(ruleID);

        this.rule = ruleID;

        if (!ruleID || !rule) {
            swc.router.navigate('network/settings/ipv6-firewall/customize', { skipUnsavedChanges: true });
        }

        this.templateData = {
            predefinedRulesList: swc.models.FirewallRules.predefined,
            ruleType: "custom",
            ruleKey: rule.get('id'),
            ruleState: rule.get('status'),
            ruleName: rule.get('name'),
            ruleProtocol: rule.get('protocol'),
            rulePortsMode: rule.get('port').length === 1 ? "single" : "range",
            rulePorts: rule.get('port'),
            rulePolicy: rule.get('policy'),
            ruleChain: rule.get('chain')
        };
    },

    /**
     * @override
     *
     * On this page save changes button should redirect user to other page after saving complete:
     */
    save: function() {
        var rulePrevious = swc.models.FirewallRules.findWhere({ id: this.rule }).toJSON(),
            ruleNew = this.serializePageData(),
            deferred = new $.Deferred();

        $.when(swc.models.FirewallRules.changeRule(rulePrevious, ruleNew))
            .done(function() {
                localStorage.setItem('firewall:change-rule', 'done');
                swc.router.navigate('network/settings/ipv6-firewall/customize', { skipUnsavedChanges: true });
            })
            .fail(function() {
                localStorage.setItem('firewall:change-rule', 'fail');
                swc.router.navigate('network/settings/ipv6-firewall/customize', { skipUnsavedChanges: true });
            });

        return deferred.promise();
    }
});
