swc.constructors.NetworkDevicesView = swc.base.PageView.extend({

    className: 'network-device-list',

    events: {
        'expandable:delete .expandable-list': 'removeDevice',

        'click .wps-pairing:not(.disabled)': 'startWpsPairing',

        'click .customize-device': 'editDevice',

        'hover .expandable-list-item:not(.expanded) .block.device-name': 'highlightIcon'
    },

    models: [
        'NetworkDevices',
        'DHCPLeases',
        'PortForwarding',
        'FirewallStatus',
        'Schedulers'
    ],

    listenerEnabled: true,

    listenerPages: [
        'network-devices'
    ],
    
    highlightIcon: function(event){
        var $icon = $(event.target).closest('.device-name').find('.device.small');

        if (event.type === 'mouseenter') {
            $icon.addClass('selected');
        } else {
            $icon.removeClass('selected');
        }
    },

    setTemplateData: function() {
        var self = this,
            devices = swc.models.NetworkDevices.getDevicesList(),
            DHCPLeases = _.pluck(swc.models.DHCPLeases.getActiveLeases(), 'MACAddress');

        var updatedDevices = _.map(devices, function (originalDevice) {
            var aDevice = _.clone(originalDevice, true);
            
            if( _.contains(DHCPLeases, aDevice.mac)) {
                aDevice.address['static'] = true;
            }

            if (aDevice.addressObjects.IPv6.length > 0) {
                $.each(aDevice.addressObjects.IPv6, function(addressKey, value) {
                    aDevice.address.IPv6[addressKey] = swc.Utils.formatIPv6Address(value.ipAddress);
                });
            }
            aDevice['portForwarding'] = self.getPortForwardingInfo(aDevice.address.IPv4);
            aDevice['parentalControlStatus'] = self.getParentalControlStatus(aDevice.mac);
            
            return aDevice;
        });
        
        this.templateData = {
            wifiState: swc.models.Wireless.getParameter("status", "status"),
            devices: updatedDevices,
            IPv6Enabled: swc.models.FirewallStatus.get('state').Enable
        };
    },

    loadModels: function(){
        var deferred = new $.Deferred();

        // Check if current page has any models:
        if (!this.models.length) {
            return deferred.resolve();
        } else {
            var temporary = [];

            // Fill in array with models to be called before page render:
            $.each(this.models, function(key, value) {
                if (!swc.models[value]) {
                    swc.models[value] = new swc.constructors[value]();
                }

                temporary.push(
                    swc.models[value].fetch()
                );
            });

            temporary.push(swc.models.Schedulers.getDevicesSchedulers());
            // Wait till all models will be fetched and process callback:
            $.when.apply(null, temporary)
                .done(function() {
                    return deferred.resolve();
                })
                .fail(function() {
                    return deferred.reject();
                });
        }

        return deferred.promise();

    },

    renderComplete: function() {},

    getParentalControlStatus: function(mac) {
        var status = false,
            scheduler = swc.models.Schedulers.get(mac);

        if (scheduler) {
            status = scheduler.get('enable');
        }

        return status;
    },

    getPortForwardingInfo: function(ip) {
        var objects = swc.models.PortForwarding.where({"deviceIP": ip}),
            jsonData = _.map(objects, function(item) {
                return item.attributes;
            });

        return jsonData;
    },

    removeDevice: function(e, mac){
        var self = this,
            ruleItem = $('.expandable-list-item[data-key="' + mac + '"]');

        ruleItem.fadeOut(function(){
            ruleItem.remove();
        });

        swc.models.NetworkDevices.removeDevice(mac);
    },

    editDevice: function(e) {
        var self = this,
            element = $(e.target),
            type = element.data('type'),
            macAddress = element.data('macaddress'),
            device = swc.models.NetworkDevices.getDevice(macAddress);

        this.customizeDevice({
            device: device,
            type: type,

            onApply: function(options) {
                self.showPageLoading("Updating device information");

                $.when(swc.models.NetworkDevices.customizeDevice(options)).done(function() {
                    self.render();
                });
            }
        });
    },

    startWpsPairing: function() {
        // lazy mixin:
        _.extend(this, swc.constructors.WpsPairingMixin);
        this.startWpsPairing();
    }

});
