swc.constructors.StorageSettingsView = swc.base.PageView.extend({

    className: 'storage-settings',

    sharingState: true,

    events: {
        'swc-switcher:change .set-ap-state': 'setApState'
    },

    listenerInterval: 5,

    listenerPages: [ 'data-sharing' ],

    models: [ 'apServiceState', 'apServiceLoadingState', 'СloudServicesStatus', 'Schedulers' ],

    setTemplateData: function() {
        var apScheduler = swc.models.Schedulers.get('ap'),
            apSchedulerState = !_.isUndefined(apScheduler) ? apScheduler.get('enabled') : false;

        this.templateData = {
            apServiceState: swc.models.apServiceState.get('status'),
            cloudServicesState: swc.models.СloudServicesStatus.get('isEnabled'),
            schedulerState: apSchedulerState
        };
    },

    /**
     * Check if application part is starting or disabled and disable / enable page
     *
     * <apState> can be :: `on`, `off`, `loading`
     */
    renderComplete: function() {
        this.updatePageUI();
    },

    onListenerComplete: function() {
        this.stopPageLoading();
        this.updatePageUI();
    },

    updatePageUI: function() {
        var self = this,
            pageState = true,
            apState = swc.models.apServiceState.get('status'),
            apServiceLoadingState = swc.models.apServiceLoadingState.get('isLoading'),
            apStateSwitcher = this.$el.find('.set-ap-state');

        // Check if AP is loading or OFF now, and disable tabs and page content
        if (apState !== true || apServiceLoadingState === true) {
            pageState = false;
        }

        // If AP has started -> fully reload page: (because of child view is not updating)
        if (pageState === true && this.isPageEnabled === false) {
            this.stopListener();
            this.render();
        } else {
            // Disable / Enable page and tabs based on page status:
            this.setPageState(pageState);
            this.setTabsState(pageState);

            // Check if AP is OFF now and show disabled message:
            if (apState === false) {
                this.showDisabledMessage({
                    container: '.apStateOffMessage',
                    className: 'above'
                });
            }

            // Check if AP is loading now and show loading message:
            if (apServiceLoadingState === true && apState === true) {
                this.showDisabledMessage({
                    container: '.apStateLoadingMessage',
                    className: 'above'
                });
            }

            // Set correct switcher position:
            apStateSwitcher.trigger('swc-switcher:swc-change', apState);

            // Start listener if page is disabled or loading:
            this.listenerEnabled = true;
            this.startListener();
        }
    },

    /**
     * Update application part status:
     * @param e {Object}
     * @param value {String}
     */
    setApState: function(e, value) {
        var self = this,
            pageRoutes = swc.settings.application.get('navigation'),
            page = Backbone.history.fragment;

        this.stopListener();
        this.listenerEnabled = true;

        this.showPageLoading("Updating Central Storage state");

        // Update parameter in the model:
        swc.models.apServiceState.set('status', value);

        // Start listener again when data saved:
        $.when(swc.models.apServiceState.sync('update')).done(function() {
            if (pageRoutes['data-sharing'] === page) {
                self.startListener();
            } else {
                swc.router.navigate(pageRoutes['data-sharing'], { skipUnsavedChanges: true });
            }
        });
    }
});
