swc.constructors.StorageSettingsDatasharingView = swc.base.TabView.extend({

    className: 'data-sharing',

    models: [ 'MediaServices', 'AfpServices', /*'UsbStatus',*/ 'RemoteNASAccess', 'RemoteNASAccounts' ],

    events: {
        'swc-checkbox:change .swc-checkbox.set-media-server-status': 'onMediaServiceStatusChange',
        'swc-checkbox:change .swc-checkbox.set-afp-status': 'onAFPStatusChange',
        'swc-checkbox:change .swc-checkbox.set-usb-3-status': 'onUsbStatusChange',
        'swc-checkbox:change .swc-checkbox.set-remote-access-status': 'onRemoteAccessStatusChange',

        'click .icons.process-delete': 'removeNASAccount'
    },

    /**
     * Serialize models and collections and pass values to the template
     */
    setTemplateData: function() {
        this.templateData = {
            mediaServerStatus: swc.models.MediaServices.get('status'),
            afpStatus: swc.models.AfpServices.get('status'),
            usbStatus: false,//swc.models.UsbStatus.get('status'),
            rnasError: swc.models.RemoteNASAccounts.isError(),
            remoteNasStatus: swc.models.RemoteNASAccess.isEnabled(),
            remoteNasAccounts: swc.models.RemoteNASAccounts.toJSON()
        };
    },

    /**
     * Update media service status in the model, after user clicked on linked checkbox
     * @param e {Object}
     * @param value {Boolean}
     */
    onMediaServiceStatusChange: function(e, value) {
        swc.models.MediaServices.set('status', value);

        // Update buttons state to see, that changes were done on the page:
        this.setButtonsState();
    },

    /**
     * Update afp status in the model, after user clicked on linked checkbox
     * @param e {Object}
     * @param value {Boolean}
     */
    onAFPStatusChange: function(e, value) {
        swc.models.AfpServices.set('status', value);

        // Update buttons state to see, that changes were done on the page:
        this.setButtonsState();
    },

    /**
     * Handle USB 3.0 Checkbox value change, show confirmation wizard / change model
     *
     * @description:
     *
     *  When user switches on `usb 3.0 standard` - he must be shown confirmation window with alert message. If user click
     *  `apply`, nothing happens, if user clicks `cancel` -> checkbox must be set to false
     *
     * @param e {Object} -> Event
     * @param value {Boolean}
     */
    onUsbStatusChange: function(e, value) {
        var self = this;

        if (value === true) {
            SWCElements.modalWindow.show({
                templateID: 'storage:settings:modal-windows:enable-usb-3',
                templateData: {},
                className: 'enable-usb-3',

                onCancel: function() {
                    self.$('.swc-checkbox.set-usb-3-status').trigger('swc-checkbox:swc-change', false);
                },

                onApply: function() {
                    self.setUsbModelStatus(value);
                    SWCElements.modalWindow.hide();
                }
            });
        } else {
            this.setUsbModelStatus(value);
        }
    },

    /**
     * Update direct USB 3.0 Model status, and set buttons state:
     * @param value {Boolean}
     */
    setUsbModelStatus: function(value) {
        //swc.models.UsbStatus.set('status', value);

        // Update buttons state to see, that changes were done on the page:
        this.setButtonsState();
    },

    /**
     * Update remote access status in the model, after user clicked on linked checkbox
     * @param e {Object}
     * @param value {Boolean}
     */
    onRemoteAccessStatusChange: function(e, value) {
        swc.models.RemoteNASAccess.set('status', value);

        // Update buttons state to see, that changes were done on the page:
        this.setButtonsState();
    },

    /**
     * Remove account from the collection of Remote Access Accounts
     * @param e {Object}
     */
    removeNASAccount: function(e) {
        var button = $(e.target).closest('.process-delete'),
            accountEmail = button.data('account'),
            accountItem = this.$el.find('.expandable-list-item[data-key="' + accountEmail + '"]'),
            accountModel = swc.models.RemoteNASAccounts.findWhere({ email: accountEmail });

        // Update model in the collection:
        swc.models.RemoteNASAccounts.remove(accountModel);

        // Remove item from the list
        accountItem.remove();

        // Update buttons state to see, that changes were done on the page:
        this.setButtonsState();
    },

    /**
     * FIXME :: when all view will be moved to new architecture remove this
     * @note page implemented using 2.0 core components
     * @override
     */
    pageCheckDefaultValues: function() {
        // NOTE: We only check other models if AP is ON and completely ready
        var isModelsChanged = function() {
            return swc.models.apServiceState.get('status') &&
                !swc.models.MediaServices.hasChanged() &&
                !swc.models.RemoteNASAccess.hasChanged() &&
                !swc.models.RemoteNASAccounts.hasChanged() &&
                !swc.models.AfpServices.hasChanged() /*&&
             !swc.models.UsbStatus.hasChanged()*/;
        };
        
        this.parentView.pageCheckDefaultValues = isModelsChanged;
        
        return isModelsChanged();
    },
    
    hasChanged: function() {
        return swc.models.apServiceState.get('status') && !this.pageCheckDefaultValues();
    },

    save: function() {
        var deferred = new $.Deferred(),
            toDo = [
                swc.models.MediaServices.sync('update'),
                swc.models.AfpServices.sync('update'),
                //swc.models.UsbStatus.sync('update'),
                swc.models.RemoteNASAccess.sync('update')
            ],
            deletedAccounts = swc.models.RemoteNASAccounts.changedModels({ onlyDeleted: true  });

        _.each(deletedAccounts, function(model, key) {
            toDo.push(
                model.sync('delete')
            );
        });

        $.when.apply(this, toDo)
            .done(function() {
                deferred.resolve();
            })
            .fail(function() {
                deferred.reject();
            });

        return deferred.promise();
    }

});
