swc.constructors.StorageSettingsCloudbackupListView = swc.base.TabView.extend({
    
    className: 'cloud-accounts',

    pageTemplateID: 'storage:settings:cloud-accounts',
    
    listenerEnabled: true,
    
    listenerPages: ['cloud-backup-list'],

    events: {
        'swc-checkbox:change .activate-cloud': 'memorizeCheckboxesState',
        'click .save-changes': 'save'
    },

    message: "",

    models: [ 'apServiceState', 'apServiceLoadingState',  'СloudServicesStatus', 'CloudServices', 'CentralStorage' ],

    checkboxes: {},

    // Dirty crutch.
    // Should be fixed in base classes to support pageTemplateID property
    // without need of initialize method overriding
    initialize: function() {
        this.template = $.template("pageContent", swc.Templates.get(this.pageTemplateID).get('content'));
        this.events = _.extend({}, swc.base.PageView.prototype.events, this.events);
    },

    preRender: function () {
        var self = this,
            deferred = new $.Deferred();

        if (!swc.models.CloudAccountCollection) {
            swc.models.CloudAccountCollection = new swc.constructors.CloudAccountCollection();
        }

        if (!swc.models.CentralStorage.isEnabled()) {
            deferred.resolve();
        } else {
            $.when(swc.models.CloudAccountCollection.sync('read'))
                .done(function () {
                    if (_.indexOf(self.models, 'CloudAccountCollection') === -1) {
                        // we need it to refresh automatically but can not add it to models from the 
                        // beginning because it is unnecessary when the Central Storage is down
                        self.models.push('CloudAccountCollection');
                    }

                    if (swc.models.CloudAccountCollection.models.length > 0) {
                        var deferredForceSyncActions = [];
                        // force sync for every account
                        // FIXME: Only sync those devices which has some trouble status
                        swc.models.CloudAccountCollection.each(function (accountModel) {
                            deferredForceSyncActions.push(accountModel.forceSyncDevice());
                        });
                        $.when.apply(this, deferredForceSyncActions)
                            // never mind, just resolve and see what we get when background listener runs sync
                            .always(function () {
                                // now re-read the whole collection
                                swc.models.CloudAccountCollection.sync('read')
                                    .always(function(){
                                        deferred.resolve();
                                    });
                            });
                    } else {
                        self.switchToCloudLoginView();
                        deferred.reject();
                    }
                })
                .fail(function () {
                    deferred.resolve();
                });
        }

        return deferred.promise();
    },

    renderComplete: function(){
        var self = this;

        var listView = new swc.base.listView({
            model: swc.models.CloudAccountCollection,
            itemView: 'cloudAccountItem',

            renderComplete: function () {
                self.restoreCheckboxes();
            }
        });

        if (!swc.models.СloudServicesStatus.get('isEnabled')) {
            this.onCloudServicesDisable();
        }

        this.$el.find('.account-list-container').replaceWith(listView.render().el);

        if (sessionStorage['clouds-saved'] === 'ok') {
            this.$('.buttons-container-message .save-success').show();
            sessionStorage.removeItem('clouds-saved');

            setTimeout(function () {
                self.$('.buttons-container-message .save-success').hide();
            }, 3000);
        }

        if (!swc.models.CentralStorage.isEnabled()) {
            this.setPageState(false);
        }
    },

    onListenerComplete: function() {
        var apServiceLoadingState = swc.models.apServiceLoadingState.get('isLoading');

        // Check if AP turned off or DBUS crashed
        if (apServiceLoadingState === true) {
            swc.router.navigate('storage/settings/data-sharing', { trigger: false, skipUnsavedChanges: true });
        } else {
            if (!swc.models.СloudServicesStatus.get('isEnabled')) {
                this.onCloudServicesDisable();
            }
        }
    },

    /**
     * Listen to cloud services `disable` event
     *
     * @description:
     *
     * <СloudServicesStatus> model is listening to TR-069 parameter, which has a flag if cloud services are enabled to
     * the user. This parameter can be set to false during user work with cloud services. This method will prevent all
     * user actions and show modal window with redirection to other page
     */
    onCloudServicesDisable: function() {
        this.stopListener();

        SWCElements.modalWindow.show({
            templateID: 'storage:settings:modal-windows:disable-cloud-services',
            templateData: {},
            className: 'disable-cloud-services',

            onApply: function() {
                SWCElements.modalWindow.hide();
                swc.router.navigate('storage/settings/data-sharing', { trigger: false, skipUnsavedChanges: true });
            }
        });
    },

    switchToCloudLoginView: function () {
        swc.router.navigate('storage/settings/cloud-backup', { trigger: false, skipUnsavedChanges: true});
    },

    memorizeCheckboxesState: function () {
        var self = this;
        this.checkboxes = {};

        if (!this.pageCheckDefaultValues()) {
            this.$('.swc-checkbox.activate-cloud').each(function () {
                var this$ = $(this),
                    id = this$.closest('.expandable-list-item').data('key');
                if (this$.data('value') !== this$.data('default-value')) {
                    self.checkboxes[id] = this$.data('value');
                }
            });
        }
    },

    // restoring checkboxes states that have been memorized in memorizeCheckboxesState()
    restoreCheckboxes: function () {
        var self = this;

        this.$('.expandable-list-item').each(function () {
            var this$ = $(this),
                id = this$.data('key'),
                checkbox = this$.find('.swc-checkbox.activate-cloud');
            if (_.has(self.checkboxes, id)) {
                checkbox.trigger('swc-checkbox:swc-change', self.checkboxes[id]);
            }
        });
    },

    save: function () {
        var self =  this,
            promises = [];

        _.each(swc.models.CloudAccountCollection.models, function (model, index) {
            // we use the memorized checkboxes states to avoid sync problem:
            if (_.has(self.checkboxes, model.id)) {
                promises.push(model.setBackupState(self.checkboxes[model.id]));
            }
        });

        $.when(promises)
            .done(function () {
                sessionStorage['clouds-saved'] = 'ok';
                swc.models.CloudAccountCollection.sync('read');
                self.checkboxes = {};
            });
    },
    
    onCancel: function () {
        this.checkboxes = {};
    }
});
