swc.constructors.StorageSchedulerView = swc.base.PageView.extend({

    className: 'storage-scheduler',

    listenerInterval: 5,

    listenerEnabled: true,

    listenerPages: [ 'storage-schedulers' ],

    models: ['apServiceState', 'apServiceLoadingState', 'Schedulers', 'ApplicationPart'],

    events: {
        'swc-switcher:change .set-ap-state': 'setApState',
        'swc-checkbox:change .enable-scheduler':'enableScheduler'
    },

    changedScheduler: false,

    setTemplateData: function() {
        var apScheduler = swc.models.Schedulers.get('ap'),
            apSchedulerState = apScheduler ? apScheduler.get('enable') : false;

        this.templateData = {
            apServiceState: swc.models.apServiceState.get('status'),
            schedulerState: apSchedulerState
        };
    },

    renderComplete: function() {
        var self = this,
            scheduler = swc.models.Schedulers.get('ap'),
            apSchedulerState = scheduler ? scheduler.get('enable') : false,
            schedulerRanges = swc.models.Schedulers.defaultScheduler.schedule;
        
        // In case if AP is Off
        if (!_.isUndefined(scheduler)) {
            schedulerRanges = scheduler.get('pixelSchedule');
        }

        this.$('.enable-scheduler').trigger('swc-checkbox:swc-change', apSchedulerState);
        
        swc.constructors.dispatcher.once('scheduler:change', function(e) {
            self.changedScheduler = true;
            self.setButtonsState();
        });

        self.schedulerDiapazon = new swc.constructors.SchedulerLiner({
            isDisabled: !apSchedulerState,
            scaleWidth: 432,
            diapazones: schedulerRanges,
            model: scheduler,
            schedulerType: 'storage'
        });

        this.$('.scheduler-container').html(self.schedulerDiapazon.el);

        this.updatePageUI();
    },

    onListenerComplete: function() {
        this.stopPageLoading();
        this.updatePageUI();
    },

    updatePageUI: function() {
        var self = this,
            pageState = true,
            apState = swc.models.apServiceState.get('status'),
            apServiceLoadingState = swc.models.apServiceLoadingState.get('isLoading'),
            apStateSwitcher = this.$el.find('.set-ap-state');

        // Check if AP is loading or OFF now, and disable tabs and page content
        if (apState !== true || apServiceLoadingState === true) {
            pageState = false;
        }

        // If AP has started -> fully reload page: (because of child view is not updating)
        if (pageState === true && this.isPageEnabled === false) {
            this.stopListener();
            this.render();
        } else {
            // Disable / Enable page and tabs based on page status:
            this.setPageState(pageState);
            this.setTabsState(pageState);

            // Check if AP is OFF now and show disabled message:
            if (apState === false) {
                this.showDisabledMessage({
                    container: '.apStateOffMessage',
                    className: 'above'
                });
            }

            // Check if AP is loading now and show loading message:
            if (apServiceLoadingState === true && apState === true) {
                this.showDisabledMessage({
                    container: '.apStateLoadingMessage',
                    className: 'above'
                });
            }

            // Set correct switcher position:
            apStateSwitcher.trigger('swc-switcher:swc-change', apState);
        }
    },

    /**
     * Update application part status:
     * @param e {Object}
     * @param value {String}
     */
    setApState: function(e, value) {
        var self = this;

        this.showPageLoading("Updating Central Storage state");

        // Update parameter in the model:
        swc.models.apServiceState.set('status', value);

        // Start listener again when data saved:
        swc.models.apServiceState.sync('update');
    },

    emptyModal: function() {
        var self = this,
            deferred = new $.Deferred();

        SWCElements.modalWindow.show({
            templateID: 'power:ap:modal',
            templateData: {
                localeStrings: swc.models.Locale.getLocaleStrings('power'),
                localeString: getTranslationStringsjQuery,
                formatDate: swc.models.Locale.formatDate
            },
            className: 'storage-schedule',
            onCancel: function() {
                SWCElements.modalWindow.hide();
                deferred.reject();
            },
            onApply: function() {
                SWCElements.modalWindow.hide();
                self.showPageLoading('Saving page data..');
                swc.models.ApplicationPart.set('serviceState', false);
                $.when(
                        swc.models.Schedulers.addSchedule('ap'),
                        swc.models.ApplicationPart.setServiceState()
                    ).done(function() {
                        deferred.resolve();
                    })
                    .fail(function() {
                        deferred.reject();
                    });
            }
        });

        return deferred.promise();
    },

    save: function() {
        var self = this,
            deferred = new $.Deferred();

        if (_.indexOf(swc.models.Schedulers.emptySchedulers, "ap") >= 0) {
            this.stopPageLoading();
            return self.emptyModal();
        } else {
            $.when(swc.models.Schedulers.addSchedule('ap'))
                .done(function() {
                    self.changedScheduler = false;
                    deferred.resolve();
                })
                .fail(function() {
                    deferred.reject();
                });
        }

        return deferred.promise();
    },
    
    pageCheckDefaultValues: function () {
        var isNotChanged = !this.changedScheduler &&
            swc.base.PageView.prototype.pageCheckDefaultValues.apply(this, arguments);
        
        if (isNotChanged) {
            this.startListener();
        } else {
            this.stopListener();
        }
        
        return isNotChanged;
    },
    
    hasChanged: function () {
        return !this.pageCheckDefaultValues();
    },

    enableScheduler: function(e, value) {
        swc.models.Schedulers.get('ap').set('enable', !!value);
        this.renderComplete();
    }

});
