swc.constructors.StorageDevicesView =  swc.base.PageView.extend({

    className: 'storage-devices-list',

    listenerInterval: 5,

    listenerEnabled: true,

    listenerPages: [ 'storage-devices' ],

    models: [ 'apServiceState', 'apServiceLoadingState', 'StorageDevices', 'Schedulers', 'System' ],

    /**
     * Defines which item is expanded at the current moment
     */
    openedItem: null,

    events: {
        'swc-switcher:change .set-ap-state': 'setApState',
        'click .remove-storage': 'unmountDevice',
        'expandable:open .expandable-list': 'onExpandableOpen',
        'expandable:close .expandable-list': 'onExpandableClose'
    },

    setTemplateData: function() {
        var self = this,
            storageDevicesArray = [],
            apScheduler = swc.models.Schedulers.get('ap'),
            apSchedulerState = !_.isUndefined(apScheduler) ? apScheduler.get('enabled') : false;

        swc.models.StorageDevices.each(function(model, index) {
            var deviceObj = {
                id: model.id,
                label: model.get('label'),
                type: model.get('type'),
                capacity: model.get('capacity'),
                freeSpace: model.get('freeSpace')
            };

            storageDevicesArray.push(deviceObj);
        });

        this.templateData = {
            apServiceState: swc.models.apServiceState.get('status'),
            schedulerState: apSchedulerState,
            devices: storageDevicesArray
        };
    },

    renderComplete: function() {
        this.updatePageUI();
        this.openExpandableItem();
    },

    onListenerComplete: function() {
        this.setTemplateData();
        this.getTemplateContent();
//        this.displayPage();

        this.updatePageUI();
        this.openExpandableItem();
//        this.stopPageLoading();
    },

    updatePageUI: function() {
        var self = this,
            pageState = true,
            apState = swc.models.apServiceState.get('status'),
            apServiceLoadingState = swc.models.apServiceLoadingState.get('isLoading'),
            apStateSwitcher = this.$el.find('.set-ap-state');

        // Check if AP is loading or OFF now, and disable tabs and page content
        if (apState !== true || apServiceLoadingState === true) {
            pageState = false;
        }

        // If AP has started -> fully reload page: (because of child view is not updating)
        if (pageState === true && this.isPageEnabled === false) {
            this.stopListener();
            this.render();
        } else {
            // Disable / Enable page and tabs based on page status:
            this.setPageState(pageState);
            this.setTabsState(pageState);

            // Check if AP is OFF now and show disabled message:
            if (apState === false) {
                this.showDisabledMessage({
                    container: '.apStateOffMessage',
                    className: 'above'
                });
            }

            // Check if AP is loading now and show loading message:
            if (apServiceLoadingState === true && apState === true) {
                this.showDisabledMessage({
                    container: '.apStateLoadingMessage',
                    className: 'above'
                });
            }

            // Set correct switcher position:
            apStateSwitcher.trigger('swc-switcher:swc-change', apState);

            // Start listener if page is disabled or loading:
            this.listenerEnabled = true;
            this.startListener();
        }
    },

    /**
     * Update application part status:
     * @param e {Object}
     * @param value {String}
     */
    setApState: function(e, value) {
        var self = this;

        this.stopListener();
        this.listenerEnabled = true;

        this.showPageLoading("Updating Central Storage state");

        // Update parameter in the model:
        swc.models.apServiceState.set('status', value);

        // Start listener again when data saved:
        $.when(swc.models.apServiceState.sync('update')).done(function() {
            self.startListener();
        });
    },

    unmountDevice: function(e) {
        var self = this,
            element = $(e.target),
            deviceId = element.closest('.expandable-list-item').data('key'),
            deviceName = swc.models.StorageDevices.get(deviceId).get('label');

        // as unmount request themselves doesn't check session state
        // the checkSessionState() method should wrap it
        swc.models.System.checkSessionState(function() {
            SWCElements.modalWindow.show({
                className: 'unmount-device',
                templateID: 'storage:settings:modal-windows:unmount-device-process',
                templateData: {
                    localeStrings: swc.models.Locale.getLocaleStrings(self.pageTemplateID),
                    localeString: getTranslationStringsjQuery,
                    formatDate: swc.models.Locale.formatDate,
                    deviceName: deviceName
                },
                onShow: function(){
                    $.when(swc.models.StorageDevices.unmountDevice(deviceId)).done(function(){
                        self.unmountConfirm(deviceName);
                    });
                }
            });
        });
    },

    unmountConfirm: function(deviceName) {
        var self = this;
        
        SWCElements.modalWindow.hide();
        SWCElements.modalWindow.show({
            templateID: 'storage:settings:modal-windows:unmount-device-complete',
            templateData: {
                localeStrings: swc.models.Locale.getLocaleStrings(self.pageTemplateID),
                localeString: getTranslationStringsjQuery,
                formatDate: swc.models.Locale.formatDate,
                deviceName: deviceName
            },
            className: 'unmount-device',
            onApply: function(){
                SWCElements.modalWindow.hide();
                self.resetExpandableItem();
                self.render();
            }
        });
    },

    resetExpandableItem: function() {
        this.openedItem = null;
    },

    openExpandableItem: function() {
        if (_.isNull(this.openedItem) && swc.models.StorageDevices.length) {
            this.openedItem = swc.models.StorageDevices.at(0).get('id');
        }

        if (!_.isNull(this.openedItem)) {
            this.$el.find('.expandable-list').trigger('expandable:swc-open', this.openedItem);
        }
    },

    onExpandableOpen: function(e, value) {
        this.openedItem = value;
    },

    onExpandableClose: function(e, value) {
        if (this.openedItem === value) {
            this.resetExpandableItem();
        }
    }
});
