swc.constructors.ApplicationView = swc.base.PageView.extend({

    /**
     * Current view class name:
     */
    className: 'application',

    hasChanges: false,

    /**
     * Events listener setup
     */
    events: {
        'click .logout': 'logout',

        'swc-dropdown:change .locale-selector': 'setLocale',

        'swc-radio-buttons:change #user-mode-switcher': 'switchUserMode'
    },

    /**
     * Initialise function has to be overrided from the base page view because of routing address missmatch
     */
    initialize: function() {
        this.template = $.template('loading', swc.Templates.get(this.className).get('content'));
    },

    /**
     * Render function has to be overrided from the base page view because of it's specific
     */
    render: function() {},

    /**
     * Render main application area:
     */
    renderApplicationArea: function() {
        var self = this,
            userModeType = swc.settings.application.get('expertMode') ? 'expert' : 'standard',
            userSuperAdmin = swc.models.Login.checkUserSuperAdmin(),
            localesOptions = swc.models.Locale.getLocaleOptions();

        // Set content to application page:
        $('#application').html($(this.el).html(
            $.tmpl(self.template, {
                jenkins: swc.settings.application.get('jenkins') || {},
                localeStrings: swc.models.Locale.getLocaleStrings('application'),
                localeString: getTranslationStringsjQuery,
                formatDate: swc.models.Locale.formatDate,
                staticPagesLinks: swc.models.Locale.getStaticPagesLinks(),
                GlobalEnable: swc.models.Application.get('GlobalEnable')
            }))
        );

        // Set locale selector values:
        $('.locale-selector').data('options', localesOptions);
        $('.locale-selector').trigger('swc-dropdown:swc-change', swc.models.Locale.locale);

        // Define content area
        this.contentArea = $("#current-page");

        // Check if user mode was selected in cookies
        if (localStorage.userMode) {
            userModeType = localStorage.userMode;

            if (localStorage.userMode === 'expert') {
                swc.settings.application.set('expertMode', true);
            } else {
                swc.settings.application.set('expertMode', false);
            }
        }

        // Set expert / standart mode to body:
        if (userModeType === 'standard') {
            $('body').removeClass('expert-mode-only').addClass('standard-mode');
        } else {
            $('body').addClass('expert-mode-only').removeClass('standard-mode');
        }

        // Add supper admin class to body to handle some features with CSS styles:
        $('body').toggleClass('superAdmin', userSuperAdmin);

        // Trigger mode switcher change
        $('#user-mode-switcher').trigger('swc-radio-buttons:swc-change', userModeType);

        this.delegateEvents();
    },

    /**
     * Update application mode basing on cookie values:
     */
    setApplicationMode: function() {
        var userModeType = swc.settings.application.get('expertMode') ? 'expert' : 'standard',
            body = $('body');

        // Define user mode type
        if (userModeType === "expert") {
            body.addClass('expert-mode-only').removeClass('standard-mode');
        } else {
            body.removeClass('expert-mode-only').addClass('standard-mode');
        }
    },

    /**
     * Update menu links when navigating to the page:
     */
    setMenuActiveLink: function() {
        var page = Backbone.history.fragment.split('/'),
            baseLink = $(this.el).find('li.menu-' + page[0]),
            tabGroup, tabLink, tabLinkBefore, tabLinkAfter,
            hasSubMenu = baseLink.find('ul').size(),
            subMenuLink;

        // Set active state of link:
        baseLink.addClass('active').siblings().removeClass('active');
        baseLink.siblings().find('ul').hide();

        // Show submenu links if they are existing
        if (hasSubMenu) {
            baseLink.find('ul').show();
        }

        // Check if routing lvl more then 1:
        if (page.length > 1) {
            subMenuLink = baseLink.find('li.page-' + page[1]);

            // Set active state of submenu links
            subMenuLink.siblings().find('a').removeClass('active');
            subMenuLink.find('a').addClass('active');
        }

        // Check if routing lvl more then 2:
        if (page.length > 2) {
            tabGroup = $(this.el).find('.page-tabs');

            if (tabGroup.size()) {
                tabLink = tabGroup.find('li.tab-' + page[2]);
                tabLinkBefore = tabLink.prev();
                tabLinkAfter = tabLink.next();

                // Set tab state active
                tabLink.addClass('active no-bg').siblings().removeClass('active no-bg');

                if (tabLinkBefore.size()) {
                    tabLinkBefore.addClass('no-bg before');
                }

                if (tabLinkAfter.size()) {
                    tabLinkAfter.addClass('after');
                }
            }
        }
    },

    /**
     * User experience mode switcher
     *
     * @param e {Object}
     *
     */
    switchUserMode: function(e, value) {
        if (value === 'standard') {
            swc.settings.application.set('expertMode', false);

            $('body').removeClass('expert-mode-only').addClass('standard-mode');
        } else {
            swc.settings.application.set('expertMode', true);

            $('body').addClass('expert-mode-only').removeClass('standard-mode');
        }

        localStorage.userMode = value;

        this.checkPermissions(true);
    },

    /**
     * Update application locale based on dropdown value
     */
    setLocale: function(e, value) {
        var self = this;

        $.when(swc.models.Locale.setLocale(value)).done(function() {
            // Clear application content:
            $('#application').html('');

            // Show loading window:
            self.showPageLoading('Loading locale strings');

            // Re-render application
            swc.router.navigate(Backbone.history.fragment);
        });
    },

    /**
     * Logout from application
     */
    logout: function() {
        swc.models.Login.processLogout({ action: 'user-logout' });
    }
});
