/**
 * Model of contacts in the phonebook
 *
 * @description:
 *
 *      this model is used to store contact information:
 *          - first name
 *          - last name
 *          - phone numbers
 *
 * @type {*}
 */
swc.constructors.PhonebookContact = swc.BaseModel.extend({

    url: {
        // keys quoted uniformly, but the reason is 'delete'
        // because IE thinks it's a key word
        'create': '/sysbus/Phonebook:addContactAndGenUUID',
        'update': '/sysbus/Phonebook:modifyContactByUniqueID',
        'delete': '/sysbus/Phonebook:removeContactByUniqueID'
    },

    phoneSet: ['HOME', 'CELL', 'WORK'],

    defaults: function() {
        var telephoneNumbers = [];

        _.each(this.phoneSet, function(phoneType) {
            telephoneNumbers.push({
                "type": phoneType,
                "preferred": false,
                "name": ''
            });
        });

        return {
            "firstName": '',
            "lastName": '',
            "formattedName": '',
            "telephoneNumbers": telephoneNumbers
        };
    },

    toJSON: function() {
        var json;

        var rawNumbers = this.get("telephoneNumbers"),
            telephoneNumbers = [
                _.where(rawNumbers, {'type': 'HOME'})[0],
                _.where(rawNumbers, {'type': 'CELL'})[0],
                _.where(rawNumbers, {'type': 'WORK'})[0]
            ];

        telephoneNumbers = _.compact(telephoneNumbers);

        _.each(telephoneNumbers, function(number){
            delete number.key;
        });

        json = {
            parameters: {
                uniqueID: this.get('id'),
                contact: {
                    name: this.getSerializedName(),
                    formattedName: this.getFormattedName(),
                    key: this.get('key'),
                    telephoneNumbers: telephoneNumbers
                }
            }
        };

        return JSON.stringify(json);
    },

    /**
     * formattedName - name that you see on phonebook.
     *
     * @example
     *      "formattedName": "Teste Mr",
     */
    getFormattedName: function() {
        return this.get('lastName') + ' ' + this.get('firstName');
    },

    /**
     * name - contact name in special format "N:"+ last name + ";" + first name.
     *
     * @example
     *      "name": "N:Mr;Teste;",
     */
    getSerializedName: function() {
        return 'N:' + this.get('lastName') + ';' + this.get('firstName');
    }

});
