swc.constructors.Screen = Backbone.Model.extend({

    sync: function(fromListener) {
        var self = this,
            deferred = new $.Deferred();

        $.when(
                self.getParameters(fromListener)
            ).done(function(){
                deferred.resolve();
            });

        return deferred.promise();
    },


    getLanguage: function(fromListener) {
        var self = this, deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/Screen:getLanguage',
            fromListener: fromListener,

            data: {
                "parameters": {}
            },

            success: function(response) {
                self.set('lang', response.status || 'EN');

                deferred.resolve();
            }
        });

        return deferred.promise();
    },

    getBrightTime: function(fromListener) {
        var self = this, deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/Screen:getBrightTime',
            fromListener: fromListener,

            data: {
                "parameters": {}
            },

            success: function(response) {
                self.set('brightTime', response.status || 60);

                deferred.resolve();
            }
        });

        return deferred.promise();
    },

    getShowPassword: function(fromListener) {
        var self = this, deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/Screen:getShowWifiPassword',
            fromListener: fromListener,

            data: {
                "parameters": {}
            },

            success: function(response) {
                self.set('showPass', response.status || false);

                deferred.resolve();
            }
        });

        return deferred.promise();
    },

    setLanguage: function(){
        var self = this, deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/Screen:setLanguage',
            data: {
                "parameters":{
                    "language" : self.get('lang')
                }
            },

            success: function(response) {
                deferred.resolve();
            }
        });

        return deferred.promise();
    },

    setBrightTime: function(){
        var self = this, deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/Screen:setBrightTime',
            data: {
                "parameters":{
                    "time" : self.get('brightTime')
                }
            },

            success: function(response) {
                deferred.resolve();
            }
        });

        return deferred.promise();
    },

    setShowPassword: function(){
        var self = this, deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/Screen:setShowWifiPassword',
            data: {
                "parameters":{
                    "enable" : self.get('showPass')
                }
            },

            success: function(response) {
                deferred.resolve();
            }
        });

        return deferred.promise();
    },

    getParameters: function(fromListener){
        var self = this, deferred = new $.Deferred();

        $.when(self.getBrightTime(fromListener), self.getLanguage(fromListener), self.getShowPassword(fromListener)).done(function(){
            deferred.resolve();
        });

        return deferred.promise();
    },

    setParameters: function(){
        var self = this, deferred = new $.Deferred();

        $.when(self.setBrightTime(), self.setLanguage(), self.setShowPassword()).done(function(){
            deferred.resolve();
        });

        return deferred.promise();
    }
});

