swc.constructors.UsbStatus = swc.BaseModel.extend({

    url: '/ws',

    ajaxParameters: JSON.stringify({
        service: 'com.swisscom.stargate/ws/nas/devices.com.swisscom.stargate.nas.devices',
        method: 'getUsbMode',
        parameters: JSON.stringify({})
    }),

    /**
     * Using try {} catch {}, because if AP is disabled, it will return not valid json
     *
     * @description
     *
     *  AP returns following response: { "status": { "data": { "mode" : 3 || 2 }, "status": 200 }}, where mode is current
     *  USB mode. Can be 2 or 3.
     *
     * @param response {Object}
     * @returns {Object}
     */
    apiToJSON: function(response) {
        var result = {
                status: false
            },
            parsedResponse;

        try {
            parsedResponse = JSON.parse(response.status);

            if (parsedResponse.data.mode) {
                result.status = parsedResponse.data.mode === 3;
            }
        } catch (e) {}

        return result;
    },

    /**
     * @description:
     *
     *  To enable usb 3.0 or 2.0, it's needed to send 3 or 2 as current mode parameter:
     *
     * @returns {*}
     */
    toJSON: function() {
        return JSON.stringify({
            service: "com.swisscom.stargate/ws/nas/devices.com.swisscom.stargate.nas.devices",
            method: "setUsbMode",
            parameters: {
                mode: this.get('status') === true ? 3 : 2
            }
        });
    }

});
