swc.constructors.RemoteNASAccess = swc.BaseModel.extend({

    url: '/ws',

    ajaxParameters: JSON.stringify({
        service: 'com.vestiacom.rnas/com/vestiacom/rnas.com.vestiacom.rnas',
        method: 'GetEnabled',
        parameters: {}
    }),

    /**
     * Using try {} catch {}, because if AP is disabled, it will return not valid json
     * 
     * @example
     * <code>
     *     // in case of error:
     *     response = {"status": "{\"status\":\"ERROR\"}"} 
     *     // or in case of success:
     *     {"status": true }
     * </code>
     * 
     * @param response {Object}
     * 
     * @returns {Object}
     */
    apiToJSON: function(response) {
        var result = {
                "status": false
            },
            responseParsed;
        
        if (response) {
            // In case of Error we will receive json-encoded string
            if (_.isString(response.status)) {
                try {
                    responseParsed = JSON.parse(response.status);
                    if (_.isObject(responseParsed)) {
                        result = responseParsed;
                    }
                } catch (e) {
                    // do nothing
                }
            } else {
                result = response;
            }
            
        } else {
            // otherwise, just set error
            result['status'] = "ERROR";
        }
        
        return result;
    },

    toJSON: function() {
        return JSON.stringify({
            service: "com.vestiacom.rnas/com/vestiacom/rnas.com.vestiacom.rnas",
            method: "SetEnabled",
            parameters: {
                enable: this.get('status')
            }
        });
    },
    
    isEnabled: function() {
        return this.get('status') === true;
    }
});
