swc.constructors.MediaServices = swc.BaseModel.extend({

    url: '/ws',

    ajaxParameters: JSON.stringify({
        service: 'com.swisscom.stargate/ws/dlna.com.swisscom.stargate.dlna',
        method: 'getMediaStreamingState',
        parameters: {}
    }),

    /**
     * Using try {} catch {}, because if AP is disabled, it will return not valid json
     * @param response {Object}
     * @returns {Object}
     */
    apiToJSON: function(response) {
        var result = {
                status: false
            },
            parsedResponse;

        try {
            parsedResponse = JSON.parse(response.status);

            if (parsedResponse.status === 200) {
                result.status = parsedResponse.data.mediaStreamingEnabled;
            }
        } catch (e) {}

        return result;
    },

    toJSON: function() {
        return JSON.stringify({
            service: "com.swisscom.stargate/ws/dlna.com.swisscom.stargate.dlna",
            method: "setMediaStreamingState",
            parameters: {
                isEnabled: this.get('status')
            }
        });
    }

});
