swc.constructors.СloudServicesStatus = swc.BaseModel.extend({

    url: '/ws',

    ajaxParameters: JSON.stringify({
        service: 'com.swisscom.stargate/ws/cloud/backup.com.swisscom.stargate.cloud.backup',
        method: 'cloudSyncEnabled',
        parameters: JSON.stringify({})
    }),

    /**
     * Using try {} catch {}, because if AP is disabled, it will return not valid json
     * @param response {Object}
     * @example { "status": "{\"data\":{\"isEnabled\":true},\"status\":200}" }
     * @returns {Object}
     */
    apiToJSON: function(response) {
        var result = {
                isEnabled: false
            },
            parsedResponse;

        try {
            parsedResponse = JSON.parse(response.status);

            if (parsedResponse.status === 200 && !_.isUndefined(parsedResponse.data)) {
                result.isEnabled = !_.isUndefined(parsedResponse.data.isEnabled) ? parsedResponse.data.isEnabled : false;
            }
        } catch (e) {}

        return result;
    }

});
