// cloud services item
swc.constructors.CloudAccount = swc.BaseModel.extend({

    fields: {
        id: '',
        cloudServiceName: '',
        deviceLabel: '',
        deviceId: '',
        accountName: '',
        status: '',
        error: '',
        totalSpace: '',
        usedSpace: '',
        lastSyncDate: '',
        folderName: ''
    },

    getExtendedJSON: function () {
        var info = this.toJSON(),
            status = this.get('status'),
            usedSpace = this.get('usedSpace'),
            totalSpace = this.get('totalSpace'),
            lastSyncDate = this.get('lastSyncDate'),
            // get server's timezone for date formatting:
            timezone = swc.settings.serverTimeZone || '';

        moment.lang(swc.models.Locale.locale);

        info.isActivated = status !== 'DISABLED';
        info.lastSync = lastSyncDate ? moment(lastSyncDate).zone(timezone).format("D MMM YYYY, HH:mm") : "";
        info.lastLogin = moment(new Date()).zone(timezone).format("D MMM YYYY, HH:mm");
        info.usedSpace = swc.Utils.getBytesWithUnit(usedSpace);
        info.freeSpace = (totalSpace < usedSpace) ? 0 : swc.Utils.getBytesWithUnit(totalSpace - usedSpace);
        info.totalSpace = swc.Utils.getBytesWithUnit(totalSpace);
        info.freePercents = (totalSpace < usedSpace) ? 0 : Math.floor(parseFloat(totalSpace - usedSpace) /
                parseFloat(totalSpace ? totalSpace : 1) * 100);

        return info;
    },

    // TODO: migrate to new API when ready
    setBackupState: function(state) {
        var self = this,
            deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/ws',
            data: {
                service: "com.swisscom.stargate/ws/cloud/backup.com.swisscom.stargate.cloud.backup",
                method: "setFolderSyncState",
                parameters: {
                    resources: JSON.stringify({
                        partitionUUID: this.get('deviceId'),
                        folderName: this.get('folderName'),
                        isEnabled: state
                    })
                }
            },

            success: function(response) {
                self.set('status', state ? 'IN_PROGRESS' : 'DISABLED');
                deferred.resolve();
            },

            error: function(response) {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    // TODO: include model.id or  something when backend is done
    logout: function (keepData) {

        var self = this,
            deferred = new $.Deferred();
        
        swc.models.Rest.sendRequest({
            url: '/ws',
            data: {
                service: "com.swisscom.stargate/ws/cloud/backup.com.swisscom.stargate.cloud.backup",
                method: "syncFSResources",
                parameters: {
                    resources: [
                        JSON.stringify({
                            deviceId: this.get('deviceId'),
                            content: [
                                JSON.stringify({
                                    path: this.get('folderName'),
                                    action: keepData ? 'REMOVE' : 'REMOVE_AND_DELETE_LOCAL_DATA'
                                })
                            ]
                        })
                    ]
                }
            },

            success: function(response) {
                // Sometimes error may happen when one try remove folder. See ticket [SA-2780].
                if (response && response.status) {
                    var result = JSON.parse(response.status);
                    
                    // some iternal server error happen, show error message
                    if (result.status === 500) {
                        return deferred.reject(result); // stop further execution
                    }
                }
                swc.models.CloudAccountCollection.sync('read');
                deferred.resolve();
            },

            error: function(){
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    forceSyncDevice: function(){
        var deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/ws',
            data: {
                "service": "com.swisscom.stargate/ws/cloud/backup.com.swisscom.stargate.cloud.backup",
                "method": "forceFailedTasksForPartition",
                "parameters": {
                    "partitionUUID": this.get("deviceId")
                }
            },

            success: function(response) {
                // Timeout is used because the board responds immediately
                // but actually needs some time to change the sync state.
                // sad but true :(
                setTimeout(function(){
                    deferred.resolve();
                }, 3000);
            }
        });

        return deferred.promise();
    }
});
