swc.constructors.apServiceState = swc.BaseModel.extend({

    url: {
        read: '/sysbus/APController/PowerManagement:getMode',
        update: '/sysbus/APController/PowerManagement:setMode'
    },

    isForceSync: true,

    apiToJSON: function(response) {
        var result = {
                status: false
            };

        if (!_.isUndefined(response.data) && !_.isUndefined(response.data.mode)) {
            result.status = response.data.mode === 'ON';
        }

        return result;
    },

    toJSON: function() {
        return JSON.stringify({
            parameters: {
                mode: this.get('status') === true ? 'ON': 'OFF'
            }
        });
    },

    /**
     * Helper method to check if AP is enabled
     * 
     * @returns {Boolean}
     */
    isEnabled: function () {
        return this.get('status');
    }

});
