swc.constructors.apServiceLoadingState = swc.BaseModel.extend({

    url: '/ws',

    ajaxParameters: JSON.stringify({
        service: 'com.swisscom.stargate/ws/core/info.com.swisscom.stargate.app',
        method: 'getApplicationStatus',
        parameters: JSON.stringify({})
    }),

    isForceSync: true,

    /**
     * Using try {} catch {}, because if AP is disabled, it will return not valid json
     * @param response {Object}
     * @returns {Object}
     */
    apiToJSON: function(response) {
        var result = {
                isLoading: true
            },
            parsedResponse;

        try {
            parsedResponse = JSON.parse(response.status);
            result = parsedResponse;

            if (!_.isUndefined(parsedResponse.status) && parsedResponse.status === "STARTED") {
                result.isLoading = false;
            }
        } catch (e) {}

        return result;
    },

    /**
     * Helper method to check if AP is completely started
     * 
     * @returns {boolean}
     */
    isApStarted: function () {
        return this.get("status") === "STARTED";
    }

});
