swc.constructors.AfpServices = swc.BaseModel.extend({

    url: '/ws',

    ajaxParameters: JSON.stringify({
        service: 'com.swisscom.stargate/ws/nas/fileservices.com.swisscom.stargate.nas.fileservices',
        method: 'list',
        parameters: JSON.stringify({})
    }),

    /**
     * Using try {} catch {}, because if AP is disabled, it will return not valid json
     * @param response {Object}
     * @returns {Object}
     */
    apiToJSON: function(response) {
        var result = {
                status: false
            },
            parsedResponse;

        try {
            parsedResponse = JSON.parse(response.status);
            
            if (parsedResponse.success) {
                result.status = _.findWhere(parsedResponse.fileServices, { service: 'AFP' }).enabled;
            }
        } catch (e) {}

        return result;
    },

    toJSON: function() {
        return JSON.stringify({
            service: "com.swisscom.stargate/ws/nas/fileservices.com.swisscom.stargate.nas.fileservices",
            method: "setState",
            parameters: {
                data: JSON.stringify({
                    service: 'AFP',
                    enabled: this.get('status')
                })
            }
        });
    }

});
