/**
 * Information about UPnP Status
 *
 * @description
 *
 *      This model is used to store information about UPnP Status. Port Forwarding related model
 *
 * @type {*}
 */
swc.constructors.UPnP = swc.BaseModel.extend({

    url: {
        read: "/sysbus/UPnP-IGD:get",
        update: "/sysbus/UPnP-IGD:set"
    },
    
    apiToJSON: function(json) {
        var data = json.status;

        return {
            status: data ? data.Enable : false
        };
    },

    toJSON: function() {
        return JSON.stringify({
            "parameters": {
                "Enable": this.get('status')
            }
        });
    }
});
