swc.constructors.PortForwardingRule = swc.BaseModel.extend({

    url: {
        // keys quoted uniformly, but the reason is 'delete'
        // because IE thinks it's a key word
        'create': '/sysbus/Firewall:setPortForwarding',
        'update': '/sysbus/Firewall:setPortForwarding',
        'delete': '/sysbus/Firewall:deletePortForwarding',
        'commit': '/sysbus/Firewall:commit'
    },

    apiToJSON: function(response) {
        return response;
    },

    toJSON: function() {
        var json = {
            parameters: {
                id: this.get('id'),
                description: this.get('name'),
                persistent: true,
                origin: 'webui',
                sourceInterface: 'data', // Scope of PF rules
                sourcePrefix: '',        // Has to be empty for PF, used for IPv6
                enable: this.get('status'),
                protocol: this.get('protocol'),
                destinationIPAddress: this.get('deviceIP'),
                internalPort: this.get('ports').destination[0],
                externalPort: this.get('ports').entry[0]
            }
        };

        if (this.get('ports').destination.length === 2) {
            json.parameters.internalPort = this.get('ports').destination.join('-');
        }

        if (this.get('ports').entry.length === 2) {
            json.parameters.externalPort = this.get('ports').entry.join('-');
        }

        // IF rule is UPnP it must be empty
        if (this.get('isUPnP')) {
            json.parameters.origin = 'upnp';
            json.parameters.sourceInterface = '';
            json.parameters.sourcePrefix = '';
        }

        return JSON.stringify(json);
    }

});
