swc.constructors.FirewallStatus = swc.base.Model.extend({

    json: {parameters:{}},

    saveJSON: {parameters:{}},

    possibleStatus: {
        "off": "Low",
        "balanced": "Medium",
        "strict": "High",
        "custom": "Custom"
    },


    getFirewallState: function(fromListener){
        var self = this,
            deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/NetMaster/IPv6/IPv6rd:get',
            fromListener: fromListener,

            data: {
                "parameters": {}
            },

            success: function(response) {
                deferred.resolve(response);
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();

    },

    getSecurityLevel: function(fromListener){
        var self = this,
            deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/Firewall:getFirewallIPv6Level',
            fromListener: fromListener,

            data: {
                "parameters": {}
            },

            success: function(response) {
                deferred.resolve(response);
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();

    },

    /*
     * Redefined sync method, because sync in base model fall down if there is param 'status' in response
     * */
    sync: function(fromListener) {
        var self = this,
            deferred = new $.Deferred();

        $.when(this.getSecurityLevel(fromListener), this.getFirewallState(fromListener))
            .done(function(level, state) {
                self.set({
                    status: level.status,
                    state: state.status
                });
                deferred.resolve();
            });

        return deferred.promise();
    },

    saveSettedLevel: function(data) {
        var self = this,
            deferred = new $.Deferred(),
            newStatus, newLevel;

        // Get neccessary params from array of page data:
        $.each(data, function(key, value) {
            if (value.parameterName === "security-level") {
                newStatus = value.parameterValue;
            }
        });

        swc.models.Rest.sendRequest({
            url: '/sysbus/Firewall:setFirewallIPv6Level',
            data: {
                "parameters": {
                    level: self.possibleStatus[newStatus]
                }
            },

            success: function(response) {
                deferred.resolve(response);
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    saveFirewallState: function(data) {
        var self = this,
            newState,
            deferred = new $.Deferred();

        // Get neccessary params from array of page data:
        $.each(data, function(key, value) {
            if (value.parameterName === "IPv6Enable") {
                newState = value.parameterValue;
            }
        });

        swc.models.Rest.sendRequest({
            url: '/sysbus/NetMaster/IPv6/IPv6rd:set',
            data: {
                "parameters": {
                    "Enable": newState
                }
            },

            success: function(response) {
                deferred.resolve(response);
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    }

});
