swc.constructors.FirewallPolicy = swc.base.Model.extend({

    actionGet: "/sysbus/Firewall:getChainPolicy",
    actionSet: "/sysbus/Firewall:setChainPolicy",

    sync: function(fromListener) {
        var self = this,
            deferred = new $.Deferred();

        $.when(
                this.makeRequest({chain: "Custom_V6In"}, this.actionGet, fromListener),
                this.makeRequest({chain: "Custom_V6Out"}, this.actionGet, fromListener)
            ).done(function(inbound, outbound){
                self.build(inbound, outbound);
                deferred.resolve();
            });

        return deferred.promise();
    },

    makeRequest: function(parameters, endpoint, fromListener){
        var deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: endpoint,
            fromListener: fromListener,
            data: {
                "parameters": parameters
            },

            success: function(response) {
                deferred.resolve(response);
            }
        });

        return deferred.promise();
    },

    build: function(inbound, outbound) {
        if (!inbound['status'] || !outbound['status'] || inbound['status'] === "None" || outbound['status'] === "None") {
            this.set({
                inbound: 'Accept',
                outbound: 'Accept'
            });
        } else {
            this.set({
                inbound: inbound['status'],
                outbound: outbound['status']
            });
        }
    },

    getValue: function(){
        var inbound = this.get('inbound'),
            outbound = this.get('outbound');

        if (!inbound || !outbound) {
            return;
        }

        return inbound + '_In-' + outbound + '_Out';
    },

    setValue: function(data) {
        var deferred = new $.Deferred(),
            self = this,
            actions,
            policy,
            toDo = [];

        // Get neccessary params from array of page data:
        $.each(data, function(key, value) {
            if (value.parameterName === "policy") {
                policy = value.parameterValue;
            }
        });

        // Parse actions to two
        actions = this.parseValue(policy);

        // Get list of request to be executed
        _.each(actions, function(action) {
            toDo.push(self.makeRequest(action, self.actionSet));
        });

        $.when.apply(null, toDo).done(function() {
            deferred.resolve();
        });

        return deferred.promise();
    },

    parseValue: function(value){
        var targets = value.split('-'),
            targetHash = {};

        _.each(targets, function(val, key){
            targetHash[val.split('_')[1]] = val.split('_')[0];
        });

        return [{chain: "Custom_V6In", policy: targetHash["In"]},
            {chain: "Custom_V6Out", policy: targetHash["Out"]}];

    },

    formatPolicyOptions: function() {
        var options = {},
            enabled = {
                "Accept_In-Accept_Out": getTranslationStrings("Allow inbound and outbound"),
                "Drop_In-Drop_Out": getTranslationStrings("Block inbound and outbound"),
                "Accept_In-Drop_Out": getTranslationStrings("Allow inbound/Block outbound"),
                "Drop_In-Accept_Out": getTranslationStrings("Block inbound/Allow outbound")
            };

        // Walk throuh all supported and enabled options
        $.each(enabled, function(key, value) {
            options[key] = {
                name:  value,
                value: key
            };
        });

        return options;
    }
});
