swc.constructors.DynDNSProvider = swc.BaseModel.extend({

    url: {
        'create': '/sysbus/DynDNS:addHost',
        'update': '',
        'delete': '/sysbus/DynDNS:delHost'
    },
    
    toJSON: function () {
        return {
            parameters: this.attributes
        };
    },

    validation: {
        service: function (data) {
            var validationMessages = [],
                validationData = swc.Utils.getDataToValidate({
                    service: { elementName: 'Service' },
                    globalStatus: { elementName: 'DynDNSEnable' }
                }, data);

            if (validationData.globalStatus === false) {
                return {
                    status: true,
                    messages: []
                };
            }

            if (!$.trim(validationData['service'])) {
                validationMessages.push("should not be empty");
            }
            
            return {
                status: _.isEmpty(validationMessages),
                messages: validationMessages
            };
        },
        
        hostname: function (data) {
            var validationMessages = [],
                validationData = swc.Utils.getDataToValidate({
                    hostname: { elementName: 'hostname' },
                    globalStatus: { elementName: 'DynDNSEnable' }
                }, data);

            if (validationData.globalStatus === false) {
                return {
                    status: true,
                    messages: []
                };
            }

            if (!$.trim(validationData['hostname'])) {
                validationMessages.push("should not be empty");
            }

            return {
                status: _.isEmpty(validationMessages),
                messages: validationMessages
            };
        },
        
        username: function (data) {
            var validationMessages = [],
                validationData = swc.Utils.getDataToValidate({
                    username: { elementName: 'username' },
                    globalStatus: { elementName: 'DynDNSEnable' }
                }, data);

            if (validationData.globalStatus === false) {
                return {
                    status: true,
                    messages: []
                };
            }

            if (!$.trim(validationData['username'])) {
                validationMessages.push("should not be empty");
            }

            return {
                status: _.isEmpty(validationMessages),
                messages: validationMessages
            };
        },
        
        password: function (data) {
            var validationMessages = [],
                validationData = swc.Utils.getDataToValidate({
                    "password": { elementName: 'password' },
                    globalStatus: { elementName: 'DynDNSEnable' }
                }, data);

            if (validationData.globalStatus === false) {
                return {
                    status: true,
                    messages: []
                };
            }

            if (!$.trim(validationData['password'])) {
                validationMessages.push("should not be empty");
            }

            return {
                status: _.isEmpty(validationMessages),
                messages: validationMessages
            };
        }
    }
    
});
