/**
 * Information about internet backup stick
 *
 * @description
 *
 *      This model is used to store information about 3G / LTE backup sticks. If internet backup stick is connected
 *
 * @type {*}
 */
swc.constructors.InternetBackupStick = swc.BaseModel.extend({

    url: "/sysbus/NeMo/Intf/wwan:getMIBs",

    apiToJSON: function(json) {
        var data = (json && json.status && json.status.wwan) ? json.status.wwan.wwan : {};

        return {
            isConnected: data.ConnectionStatus === "Connected",
            status: data.ConnectionStatus,
            provider: data.APN,
            technology: data.Technology,
            signalLevel: data.SignalStrength
        };
    }

});