swc.constructors.PasswordRecovery = swc.BaseModel.extend({
    
    url: {
        "read": "/sysbus/PasswordRecovery:getStatus",
        "update": "/sysbus/PasswordRecovery:setEnable"
    },
    
    defaults: {
        'recoveryEnable': false,
        'recoveryStatus': null
    },

    apiToJSON: function (response) {
        if (!response || !response.status) {
            return {
                recoveryEnable: false,
                recoveryStatus: false
            };
        }
        return {
            recoveryEnable: response.status[0],
            recoveryStatus: response.status[1]
        };
    },
    
    toJSON: function () {
        return {
            parameters: {
                Enable: this.get('recoveryEnable')
            }
        };
    },
    
    startProcess: function () {
        var deferred = new $.Deferred();
        
        swc.models.Rest.sendRequest({
            url: '/sysbus/PasswordRecovery:start',
            data: {
                parameters: {}
            },
            
            success: function () {
                deferred.resolve();
            },
            
            error: function () {
                deferred.reject();
            }
        });
            
        return deferred.promise();
    },
    
    stopProcess: function () {
        var deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/PasswordRecovery:stop',
            data: {
                parameters: {}
            },

            success: function () {
                deferred.resolve();
            },

            error: function () {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    /**
     * Short method to check if Recovery Process is currently running
     * 
     * @returns {boolean}
     */
    isRecoveryRunning: function(){
        return this.get("recoveryStatus") === "Processing";
    },

    setNewPassword: function(password) {
        var self = this,
            deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/PasswordRecovery:setPassword',
            data: {
                parameters: {
                    password: password
                }
            },

            success: function(response) {
                deferred.resolve(response.status);
            }
        });

        return deferred.promise();
    }
    
});
