swc.constructors.EventManager = swc.BaseModel.extend({
    
    url: "/ws",

    ajaxSettings: {
        requestType: 'POST',
        requestDataType: 'json',
        contentType: "application/x-sah-event-1-call+json"
    },

    defaults: {
        "channelid": 0, // mark that subscription channel should be created
        "events": []
    },
    
    /**
     * Creates an Event-Manager channel to listen for subscribed events
     * 
     * @returns Promise
     */
    openChannel: function() {
        var deferred = new $.Deferred();
        
        $.when(this.sync("create", {silent: true}))
            .done(function () {
                deferred.resolve();
            })
            .fail(function() {
                deferred.reject();
            });
        
        return deferred.promise();
    }
});

/**
* This is just a helper Object to be passed into EventManagerListener
*/
swc.constructors.StargateEvent = swc.BaseModel.extend();

swc.constructors.EventManagerListener = swc.BaseCollection.extend({
    
    url: "/ws",
    
    model: 'StargateEvent',

    ajaxSettings: {
        requestType: 'POST',
        requestDataType: 'json',
        contentType: "application/x-sah-event-1-call+json"
    },

    defaults: {
        "channelid": 0, // mark that subscription channel should be crerated
        "events": []
    },
    
    apiToJSON: function (response) {
        /**
         * Example response would be:
         * {"channelid":12,"events":[{"data":{"handler":"Screen","object":{"reason":"PasswordRecovery","attributes":{"response":"Allowed"}}}}]}
         */
        var result = [];
        
        if (!_.isEmpty(response.events)) {
            _.each(response.events, function (elem) {
                result.push({
                    "handler": elem.data.handler,
                    "reason": elem.data.object.reason,
                    "attributes": elem.data.object.attributes
                });
            });
        }
        
        return result;
    },

    setAjaxParameters: function (ajaxParameters) {
        this.ajaxParameters = ajaxParameters;
    },
    
    /**
     * Listen to subscribed events using currently opened channel
     */
    listenChannel: function() {
        var deferred = new $.Deferred();

        $.when(this.sync("read", {silent: false}))
            .done(function () {
                deferred.resolve();
            })
            .fail(function() {
                deferred.reject();
            });

        return deferred.promise();
    }
});
