swc.constructors.ApplicationModel = Backbone.Model.extend({

    /**
     * Init application model
     */
    initialize: function() {
        var self = this;
        // Load templates and necessary scripts:
        swc.Templates = swc.Templates ? swc.Templates : new swc.constructors.Templates();
        swc.Templates.loadTemplates(function() {
            swc.models.Locale = new swc.constructors.LocaleModel();

            var storedLocal = localStorage.getItem("locale");
            // When it is the very first run or cache and local storage are cleared
            if (!storedLocal) {
                self.initLocaleFallback();
            }
            // otherwise - get locale preference from the serverside
            else {
                $.when(swc.models.Locale.getLocale())
                    .done(function(response){
                        $.when(swc.models.Locale.setLocale(response.status))
                            .always(function() {
                                self.initComponents();
                            });
                    })
                    .fail(function(){
                        self.initLocaleFallback();
                    });
            }
        });
    },

    sync: function(fromListener) {
        var deferred = $.Deferred();

        $.when(this.getAPGlobalState(fromListener), swc.models.PasswordRecovery.sync("read", { isListener: fromListener }))
            .always(function() {
                deferred.resolve();
            });

        return deferred.promise();
    },

    /**
     * Fallback mechanism to get locale from local storage or default settings
     * and save it on server side
     *
     * @return void
     */
    initLocaleFallback: function() {
        var self = this;
        var appLocale = getApplicationLocale(swc.models.Locale.available);
        if (appLocale === "undefined") {
            appLocale = swc.models.Locale.defaultLocale;
        }
        // save locale preference on server side
        $.when(swc.models.Locale.setLocale(appLocale)).always(function() {
            self.initComponents();
        });
    },

    /**
     * Init core models and views
     *
     * @return void
     */
    initComponents: function() {
        var self = this;

        // we have to have PasswordRecovery model in order to show link on login page
        swc.models.PasswordRecovery = new swc.constructors.PasswordRecovery();
        
        // Init basic views:
        swc.views.Application = new swc.constructors.ApplicationView();
        swc.views.Login = new swc.constructors.LoginView();

        // Init basic models:
        swc.models.Login = new swc.constructors.LoginModel();
        swc.models.Rest = new swc.constructors.Rest();

        // Need to get all login information because of incorrect implementation of login model
        $.when(this.sync())
            .done(function() {
                self.coreRun();
            })
            .fail(function() {
                self.coreRun();
            });
    },

    /**
     * Gets an example of time from server and keeps it in swc.settings
     * Is used for formatting dates in server's timezone.
     */
    initServerTimeZone: function() {
        var self = this,
            onRequestComplete = function(response) {
                if (response && response.data && response.data.time) {
                    swc.settings.serverTimeZone = moment.parseZone(response.data.time).zone();
                } else {
                    setTimeout(function() {
                        self.initServerTimeZone();
                    }, 1000);
                }
            };

        swc.models.Rest.sendRequest({
            url: '/sysbus/Time:getTime',
            fromListener: true,
            timeout: 1000,
            data: {
                "parameters": {}
            },
            success: onRequestComplete,
            error: onRequestComplete
        });
    },

    /**
     * Start application:
     */
    coreRun: function() {
        var userLogin = swc.models.Login.checkUserLogin();

        if (userLogin) {
            this.initServerTimeZone();
            //swc.models.Login.loginStatusListener();
        }

        // Pre render application area if user is logged in:
        if (window.isOnStickyPage){
            Backbone.history.start(); // no router, so need to do this
            swc.views.StickyPageView = new swc.constructors.StickyPageView();
        } else {
            // Init Application Router:
            swc.router = swc.router ? swc.router : new swc.constructors.Router();
        }
    },

    // get global AP state
    getAPGlobalState: function(fromListener) {
        var self = this,
            deferred = new $.Deferred();

        // Just in case ;-) Actually we call swc.settings throughout all application
        self.set('domainName', swc.settings.application.get('url'));

        swc.models.Rest.sendRequest({
            url: '/sysbus/APController:get',
            fromListener: fromListener,
            data: {
                parameters: {}
            },

            success: function(response) {
                if (response.status !== null) {
                    self.set(response.status);
                    self.set(response.status);
                } else {
                    self.set({
                        GlobalEnable: false,
                        DNSName: swc.settings.application.get('apUrl')
                    });
                }
                deferred.resolve();
            },

            error: function() {
                self.set({
                    GlobalEnable: false,
                    DNSName: swc.settings.application.get('apUrl')
                });
            }
        });

        return deferred.promise();
    }
});
