swc.constructors.DeviceMeasurements = Backbone.Collection.extend({

    getRequest: function(params, fromListener) {
        var deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/NeMo/Intf/data:getMIBs',
            data: {
                "parameters": params
            },
            fromListener: fromListener,

            success: function(response) {
                deferred.resolve(response);
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    sync: function(fromListener) {
        var deferred = new $.Deferred(),
            self = this;

        $.when(this.getRequest({mibs: "dsl"}, fromListener), this.getRequest({mibs: "sfp"}, fromListener))
            .done(function(dsl, sfp){
                self.build(dsl, sfp);
                deferred.resolve();
            });

        return deferred.promise();
    },

    build: function(dsl, sfp) {
        var dslObj,
            sfpObj,
            self = this;

        if (dsl && dsl['status'] && dsl['status']['dsl']){
            _.each(dsl['status']['dsl'], function(obj, key){
                if (_.isEmpty(obj)) {
                    return;
                }
                dslObj = obj;
                dslObj.__key__ = key;
                dslObj.id = "dsl";
                self.add(dslObj);
            });
        }

        if (sfp && sfp['status'] && sfp['status']['sfp']){
            _.each(sfp['status']['sfp'], function(obj, key){
                if (_.isEmpty(obj)) {
                    return;
                }

                sfpObj = obj;
                sfpObj.__key__ = key;
                sfpObj.id = "sfp";
                self.add(sfpObj);
            });
        }
    },

    getParams: function() {
        var dsl = this.get("dsl"),
            sfp = this.get("sfp");

        if (dsl){
            return {dsl: dsl.toJSON()};
        } else if (sfp){
            return {sfp: sfp.toJSON()};
        }

        return {};
    }
});
