swc.constructors.RemoteNASAccounts = swc.BaseCollection.extend({

    model: 'RemoteNASAccount',

    url: {
        read: '/ws'
    },

    ajaxParameters: JSON.stringify({
        service: 'com.vestiacom.rnas/com/vestiacom/rnas.com.vestiacom.rnas',
        method: 'GetPairing',
        parameters: {}
    }),

    /**
     * @example Success Response:
     *
     * { "status": "SUCCESS", "accounts": [{ "name": "n1", "email": "e1" }, { "name": "n2", "email": "e2" }] }
     *
     * @example Fail Response:
     *
     * {"status":"ERROR"}
     */
    apiToJSON: function(response) {
        var accountsParsed = [],
            responseParsed = {};

        this.error = false;

        try {
            responseParsed = JSON.parse(response.status);

            if (!_.isEmpty(responseParsed) && responseParsed.status === "SUCCESS") {
                var rnasAccounts = responseParsed.accounts;

                _.each(rnasAccounts, function(account) {
                    accountsParsed.push({
                        id: account.email,
                        name: account.name,
                        email: account.email
                    });
                });
            }

            if (responseParsed.status !== "SUCCESS") {
                this.error = true;
            }
        } catch (e) {}

        return accountsParsed;
    },

    isError: function () {
        return this.error === true;
    }

});
