swc.constructors.DynDNSService = Backbone.Model.extend({
    defaults: {
        id: '',
        name: ''
    }
});

swc.constructors.DynDNSServiceCollection = swc.BaseCollection.extend({
    
    url: {
        'read': '/sysbus/DynDNS:getServices'
    },
    
    model: 'DynDNSService',
    
    apiToJSON: function (response) {
        var result = [];
        
        _.each(response.status, function (providerId) {
            result.push({
                id: providerId,
                name: providerId
            });
        });
        
        return result;
    },

    /**
     * Prepare options for the Service provider dropdown list
     * @returns {Array}
     */
    formatProvidersOptions: function() {
        var options = [];

        this.each(function(provider) {
            options.push({
                name:  provider.get('name').capitalize(),
                value: provider.get('name')
            });
        });
        
        return options;
    }
    
});
