swc.constructors.DynDNSProviderCollection = swc.BaseCollection.extend({
    
    url: {
        read: '/sysbus/DynDNS:getHosts'
    },
    
    model: 'DynDNSProvider',
    
    defaults: {
        'id': '',
        'service': '',
        'hostname': '',
        'username': '',
        'password': '',
        'last_update': null,
        'status': null,
        'enable': false
    },
    
    // Parses host list
    apiToJSON: function (response) {
        var result = [];
        
        _.each(response.status, function(providerData) {
            // Manually create ID. From NP point of view it is a "hostname"
            providerData['id'] = providerData['hostname'];
            result.push(providerData);
        });
        
        return result;
    }
    
});
