swc.constructors.DHCPLeases = Backbone.Collection.extend({

    sync: function(fromListener){
        var deferred = new $.Deferred(),
            self = this;

        swc.models.Rest.sendRequest({
            url: '/sysbus/DHCPv4/Server/Pool/default:getStaticLeases',
            fromListener: fromListener,

            data: {
                "parameters":{ }
            },

            success: function(response) {
                self.build(response);
                deferred.resolve();
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    build: function(response){
        var self = this;

        this.reset();

        if (!response || !response['status']) {
            return;
        }

        _.each(response['status'], function(data, id){
            var model = new Backbone.Model();
            if (data.MACAddress) {
                data.MACAddress = data.MACAddress.toUpperCase();
            }
            model.set({'id': data.MACAddress});
            model.set(data);
            self.add(model);
        });
    },

    getActiveLeases: function(){
        var data = [],
            res = {};

        data = _.map(this.toJSON(), function(model){
            var mac = model.MACAddress,
                device = swc.models.NetworkDevices.where({mac: mac});

            if (device.length) {
                model['device'] = device[0].toJSON();
            } else {
                model['device'] = {};
            }

            return model;
        });

        _.each(data, function(item){
            res[item.MACAddress] = item;
        });

        return res;
    },

    saveDHCPLeasesEdit: function(data){
        var self = this,
            ipaddr, macaddr, device, edited, deleted = false,
            deferred = new $.Deferred(),
            editedId;

        $.each(data, function(key, value) {
            if (value.parameterName === "DHCPLeaseIPAddress") {
                ipaddr = value.parameterValue;
            }
            if (value.parameterName === "DHCPLeaseEditedMacAddress") {
                macaddr = value.parameterValue;
            }
            editedId = value.parameterData.editedLease;
        });

        $.when(this.deleteDHCPLease(editedId)).done(function() {
            if (data.deleted) {
                deferred.resolve();
            } else {
                $.when(self.saveDHCPLeaseRequest(ipaddr, macaddr)).done(function() {
                    deferred.resolve();
                });
            }
        });

        return deferred.promise();
    },

    saveDHCPLeases: function(data){
        var self = this,
            pool = [],
            deferred = new $.Deferred();

        $.each(data, function(key, value) {
            pool.push(self.saveDHCPLease(value));
        });

        $.when(pool).done(function () {
            deferred.resolve();
        }).fail(function () {
            deferred.reject();
        });

        return deferred.promise();
    },

    saveDHCPLease: function(data){
        var self = this,
            ipaddr, macaddr, device, edited = false;

        // Get neccessary params from array of page data:
        $.each(data, function(key, value) {
            if (value.parameterName === "DHCPLeaseIPAddress") {
                ipaddr = value.parameterValue;
            }
            if (value.parameterName === "DHCPLeaseMacAddress") {
                macaddr = value.parameterValue;
            }
            if (value.parameterName === "DHCPLeaseEditedMacAddress") {
                edited = true;
            }
        });

        if (edited) {
            return this.saveDHCPLeasesEdit(data);
        }

        return this.saveDHCPLeaseRequest(ipaddr, macaddr);
    },

    saveDHCPLeaseRequest: function(ip, mac){
        var deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/DHCPv4/Server/Pool/default:addStaticLease',
            data: {
                parameters: {
                    IPAddress: ip,
                    MACAddress: mac
                }
            },

            success: function(response) {
                deferred.resolve();
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();

    },

    deleteDHCPLease: function(mac){
        var deferred = new $.Deferred(),
            self = this;

        swc.models.Rest.sendRequest({
            url: '/sysbus/DHCPv4/Server/Pool/default:deleteStaticLease',
            data: {
                parameters: {
                    MACAddress: mac
                }
            },

            success: function(response) {
                self.remove(mac);
                deferred.resolve();
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    validation: {
        validateNewDevice: function(data){
            var device, isEdited = false, ipAddress,
                validationStatus = {
                    'status': true,
                    'messages': []
                };

            // Get neccessary params from array of page data:
            $.each(data, function(key, value) {
                if (value.parameterName === "DHCPLeaseNewDevice" || value.parameterName === "DHCPLeaseNewDevice") {
                    device = value.parameterValue;
                }

                if (value.parameterName === "DHCPLeaseEditFlag" && value.parameterValue) {
                    isEdited = true;
                }

                if (value.parameterName === "DHCPLeaseIPAddress") {
                    ipAddress = value.parameterValue;
                }
            });

            if (!isEdited && (_.isEmpty(device)) && (ipAddress && ipAddress !== "")){
                validationStatus.status = false;
                validationStatus.messages.push("global");
            }

            return validationStatus;
        },

        validateIP: function(data){
            var netValidation = swc.models.Network.validation,
                validationStatus = {
                    'status': true,
                    'messages': []
                };

            var Address = netValidation.getIPField(data, 'Address'),
                Netmask = netValidation.getIPField(data, 'Netmask'),
                DHCPMin = netValidation.getIPField(data, 'DHCPRange', 'range-from'),
                DHCPMax = netValidation.getIPField(data, 'DHCPRange', 'range-to'),
                LeaseIPAddress = netValidation.getIPField(data, 'DHCPLeaseIPAddress'),
                LeaseIPAddressStr = netValidation.decimalToIpString(LeaseIPAddress),
                DHCPLease = (_.findWhere(data, {parameterName: 'DHCPLeaseMacAddress'}) || _.findWhere(data, {parameterName: 'DHCPLeaseEditedMacAddress'})),
                DHCPLeaseMacAddress = DHCPLease ? DHCPLease.parameterValue : false;

            // NOTE: copy-pasted from network.js file
            var Subnet = (Address & Netmask) >>> 0;
            var Broadcast = (Address | ~Netmask) >>> 0;
            
            if (Address === false || Netmask === false || DHCPMin === false || DHCPMax === false) {
                return validationStatus;
            }

            var editedModelId = _.findWhere(data, { parameterName: "DHCPLeaseEditFlag" });
            
            if (editedModelId && editedModelId.parameterValue) {
                editedModelId = editedModelId.parameterValue;
            } else {
                editedModelId = false;
            }

            // Check if format is valid
            if (LeaseIPAddress === false) {
                validationStatus.status = false;
                validationStatus.messages.push('Invalid IPv4 Address Format Custom');
                return validationStatus;
            }

            // Check if address is within right subnet
            if (!netValidation.isAddressWithinSubnet(LeaseIPAddress, Address, Netmask)) {
                validationStatus.status = false;
                validationStatus.messages.push('IPv4 Address is outside of allowed host addresses range');
                return validationStatus;
            }

            // NOTE: copy-pasted from network.js file [BEGIN]
            if (LeaseIPAddress === Broadcast) {
                validationStatus.status = false;
                validationStatus.messages.push("Not match broadcast");
                return validationStatus;
            }

            if (LeaseIPAddress === Subnet) {
                validationStatus.status = false;
                validationStatus.messages.push("Not match subnet");
                return validationStatus;
            }
            // [END]

            // if (DHCPMin <= LeaseIPAddress && LeaseIPAddress <= DHCPMax) {
            //     validationStatus.status = false;
            //     validationStatus.messages.push('IPv4 Address Within DHCP Range');
            //     return validationStatus;
            // }
            
            // Validate that address is unique
            if (LeaseIPAddress === Address) {
                validationStatus.status = false;
                validationStatus.messages.push('IPv4 Address Already in use');
                return validationStatus;
            }

            swc.models.NetworkDevices.each(function(model){
                var modelAddress = model.get('address'),
                    modelMac = model.get('mac');
                
                if (modelAddress.IPv4 === LeaseIPAddressStr && DHCPLeaseMacAddress && modelMac !== DHCPLeaseMacAddress) {
                    validationStatus.status = false;
                    validationStatus.messages.push('IPv4 Address Already in use');
                }
            });

            swc.models.DHCPLeases.each(function(model){
                if ((model.get("IPAddress") === LeaseIPAddressStr) && (model.get("id") !== editedModelId)) {
                    validationStatus.status = false;
                    validationStatus.messages.push('IPv4 Address Already in use');
                }
            });
            
            return validationStatus;
        }
    }

});
