var mkdirp = require('mkdirp');
    fs     = require('fs'),
    path   = require('path');

exports.save = function(req, res, next) {
    var oldEnd = res.end;
        oldWrite = res.write,
        chunks = [],
        fixtureData = {
            url: req.url
        };

    res.write = function(chunk) {
        chunks.push(chunk);
        oldWrite.apply(res, arguments);
    };

    res.end = function(chunk) {
        var body;

        if (chunk) {
            chunks.push(chunk);
        }

        if (isFixture(fixtureData.url)) {
            body = Buffer.concat(chunks).toString('utf8');
            fixtureData['response'] = body;
            saveFixtures(fixtureData);
        }

        oldEnd.apply(res, arguments);
    };

    if (isFixture(fixtureData.url)) {
        req.on('data', function(data) {
            fixtureData['request'] = data.toString();
        });
    };

    next();
}

/**
* Determines if passed url has fixtures and they must be saved
*
* @return {Boolean} Returns true on success
*/
function isFixture(url) {
    if (url.indexOf('/static/') !== -1 || url.indexOf('/application/') !== -1 || url === '/') {
        return false;
    }

    return true;
};

/**
* Creates directories for response.json and request.json files
* based on the fixture url
*
* @param {Object} fixture A fixture object, example {url: '/ws', response: "", request: ""}
* @return void
*/
function saveFixtures(fixtureData) {
    var fixtureData = fixtureData || {},
        dirPath = ["./tests/fixtures"],
        fixtureRequestObj,
        requestFilePath,
        responseFilePath;

    if (fixtureData.url === '/ws') {
        try {
            fixtureRequestObj = JSON.parse(fixtureData.request);
            dirPath.push(fixtureData.url, fixtureRequestObj.service, fixtureRequestObj.method);
        } catch(e) {
            console.log(e);
        }
    } else if (fixtureData.url.indexOf('/LAN?_=') !== -1) {
        dirPath.push(fixtureData.url.replace(/\d+/, ''));
    } else {
        dirPath.push(fixtureData.url);
    }

    dirPath = path.join.apply(null, dirPath);

    requestFilePath = dirPath + "/request.json",
    responseFilePath= dirPath + "/response.json";

    mkdirp(dirPath, function(err) {
        fs.writeFile(requestFilePath, fixtureData.request ? fixtureData.request:'', function(err) {});
        fs.writeFile(responseFilePath, fixtureData.response ? fixtureData.response:'', function(err) {});
    });
};